/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2025 Icenowy Zheng <uwu@icenowy.me>
 *
 * Based on vs_dc_hw.h, which is:
 *   Copyright (C) 2023 VeriSilicon Holdings Co., Ltd.
 */

#ifndef _VS_BRIDGE_REGS_H_
#define _VS_BRIDGE_REGS_H_

#include <linux/bits.h>

#define VSDC_DISP_PANEL_CONFIG(n)		(0x1418 + 0x4 * (n))
#define VSDC_DISP_PANEL_CONFIG_DE_EN		BIT(0)
#define VSDC_DISP_PANEL_CONFIG_DE_POL		BIT(1)
#define VSDC_DISP_PANEL_CONFIG_DAT_EN		BIT(4)
#define VSDC_DISP_PANEL_CONFIG_DAT_POL		BIT(5)
#define VSDC_DISP_PANEL_CONFIG_CLK_EN		BIT(8)
#define VSDC_DISP_PANEL_CONFIG_CLK_POL		BIT(9)
#define VSDC_DISP_PANEL_CONFIG_RUNNING		BIT(12)
#define VSDC_DISP_PANEL_CONFIG_GAMMA		BIT(13)
#define VSDC_DISP_PANEL_CONFIG_YUV		BIT(16)

#define VSDC_DISP_DPI_CONFIG(n)			(0x14B8 + 0x4 * (n))
#define VSDC_DISP_DPI_CONFIG_FMT_MASK		GENMASK(2, 0)
#define VSDC_DISP_DPI_CONFIG_FMT_RGB565		(0)
#define VSDC_DISP_DPI_CONFIG_FMT_RGB666		(3)
#define VSDC_DISP_DPI_CONFIG_FMT_RGB888		(5)
#define VSDC_DISP_DPI_CONFIG_FMT_RGB101010	(6)

#define VSDC_DISP_PANEL_START			0x1CCC
#define VSDC_DISP_PANEL_START_RUNNING(n)	BIT(n)
#define VSDC_DISP_PANEL_START_MULTI_DISP_SYNC	BIT(3)

#define VSDC_DISP_DP_CONFIG(n)			(0x1CD0 + 0x4 * (n))
#define VSDC_DISP_DP_CONFIG_DP_EN		BIT(3)
#define VSDC_DISP_DP_CONFIG_FMT_MASK		GENMASK(2, 0)
#define VSDC_DISP_DP_CONFIG_FMT_RGB565		(0)
#define VSDC_DISP_DP_CONFIG_FMT_RGB666		(1)
#define VSDC_DISP_DP_CONFIG_FMT_RGB888		(2)
#define VSDC_DISP_DP_CONFIG_FMT_RGB101010	(3)
#define VSDC_DISP_DP_CONFIG_YUV_FMT_MASK	GENMASK(7, 4)
#define VSDC_DISP_DP_CONFIG_YUV_FMT_UYVY8	(2 << 4)
#define VSDC_DISP_DP_CONFIG_YUV_FMT_YUV8	(4 << 4)
#define VSDC_DISP_DP_CONFIG_YUV_FMT_UYVY10	(8 << 4)
#define VSDC_DISP_DP_CONFIG_YUV_FMT_YUV10	(10 << 4)
#define VSDC_DISP_DP_CONFIG_YUV_FMT_UYYVYY8	(12 << 4)
#define VSDC_DISP_DP_CONFIG_YUV_FMT_UYYVYY10	(13 << 4)

#define VSDC_DISP_PANEL_CONFIG_EX(n)		(0x2518 + 0x4 * (n))
#define VSDC_DISP_PANEL_CONFIG_EX_COMMIT	BIT(0)

#endif /* _VS_BRIDGE_REGS_H_ */
