/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.10*/
#include "mp_precomp.h"

#define ODM_WIN 0x08

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE

#if (RTL8822C_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8822c_radioa[] = {
		0x000, 0x00030000,
		0x018, 0x00013124,
		0x093, 0x0008483F,
		0x0DE, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000B9140,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000B9140,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0xA0000000,	0x00000000,
		0x08E, 0x000A5540,
	0xB0000000,	0x00000000,
		0x081, 0x0000FC01,
		0x081, 0x0002FC01,
		0x081, 0x0003FC01,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0xA0000000,	0x00000000,
		0x085, 0x0006A06C,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773E8,
		0x033, 0x0000000E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000D,
		0x03F, 0x00000380,
		0x033, 0x0000000C,
		0x03F, 0x000FF380,
		0x033, 0x0000000B,
		0x03F, 0x00000300,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773E8,
		0x033, 0x0000001E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001D,
		0x03F, 0x00000380,
		0x033, 0x0000001C,
		0x03F, 0x000FF380,
		0x033, 0x0000001B,
		0x03F, 0x00000300,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773E8,
		0x033, 0x0000002E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002D,
		0x03F, 0x00000380,
		0x033, 0x0000002C,
		0x03F, 0x000FF380,
		0x033, 0x0000002B,
		0x03F, 0x00000300,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773E8,
		0x033, 0x0000003E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003D,
		0x03F, 0x00000380,
		0x033, 0x0000003C,
		0x03F, 0x000FF380,
		0x033, 0x0000003B,
		0x03F, 0x00000300,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773E8,
		0x033, 0x0000004E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004D,
		0x03F, 0x00000380,
		0x033, 0x0000004C,
		0x03F, 0x000FF380,
		0x033, 0x0000004B,
		0x03F, 0x00000300,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000043,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773E8,
		0x033, 0x0000005E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005D,
		0x03F, 0x00000380,
		0x033, 0x0000005C,
		0x03F, 0x000FF380,
		0x033, 0x0000005B,
		0x03F, 0x00000300,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000053,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x08A, 0x000E7DE3,
		0x08B, 0x0008FE00,
		0x0EE, 0x00000008,
		0x033, 0x00000000,
		0x03F, 0x00000023,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x0EE, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000010,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
		0x01B, 0x00003A40,
		0x061, 0x0000D233,
		0x062, 0x0004D232,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x063, 0x00000C02,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0xA0000000,	0x00000000,
		0x030, 0x00000233,
		0x030, 0x00001233,
		0x030, 0x00002233,
		0x030, 0x00003233,
		0x030, 0x00004203,
		0x030, 0x00005233,
		0x030, 0x00006233,
		0x030, 0x00007233,
		0x030, 0x00008203,
		0x030, 0x00009233,
		0x030, 0x0000A233,
		0x030, 0x0000B233,
		0x030, 0x0000C233,
		0x030, 0x0000D233,
		0x030, 0x0000E203,
		0x030, 0x0000F233,
		0x030, 0x00010233,
		0x030, 0x00011233,
		0x030, 0x00012203,
		0x030, 0x00013233,
		0x030, 0x00014233,
		0x030, 0x00015233,
		0x030, 0x00016203,
		0x030, 0x00017233,
		0x030, 0x00018203,
		0x030, 0x00019233,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0xA0000000,	0x00000000,
		0x030, 0x00000232,
		0x030, 0x00001232,
		0x030, 0x00002232,
		0x030, 0x00003232,
		0x030, 0x00004232,
		0x030, 0x00005232,
		0x030, 0x00006232,
		0x030, 0x00007232,
		0x030, 0x00008232,
		0x030, 0x00009232,
		0x030, 0x0000A232,
		0x030, 0x0000B232,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000770,
		0x030, 0x00001770,
		0x030, 0x00002440,
		0x030, 0x00003440,
		0x030, 0x00004330,
		0x030, 0x00005330,
		0x030, 0x00008770,
		0x030, 0x0000A440,
		0x030, 0x0000C330,
		0x0EF, 0x00000000,
		0x0EE, 0x00010000,
	0x83000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x83000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x83000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
		0x051, 0x0003C800,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0xA0000000,	0x00000000,
		0x052, 0x000942CA,
	0xB0000000,	0x00000000,
		0x053, 0x000090F9,
		0x054, 0x00088000,
		0x057, 0x0004C80A,
		0x0EF, 0x00000020,
		0x033, 0x00000000,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00010000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000487,
		0x033, 0x00000061,
		0x03F, 0x00000887,
		0x033, 0x00000062,
		0x03F, 0x00000947,
		0x033, 0x00000063,
		0x03F, 0x00000D48,
		0x033, 0x00000064,
		0x03F, 0x00000D88,
		0x033, 0x00000065,
		0x03F, 0x00000DE8,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000487,
		0x033, 0x00000021,
		0x03F, 0x00000887,
		0x033, 0x00000022,
		0x03F, 0x00000947,
		0x033, 0x00000023,
		0x03F, 0x00000D48,
		0x033, 0x00000024,
		0x03F, 0x00000D88,
		0x033, 0x00000025,
		0x03F, 0x00000DE8,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x05C, 0x000FC000,
		0x067, 0x0000A505,
		0x0D3, 0x00000542,
		0x043, 0x00005000,
		0x07F, 0x00000000,
		0x0B0, 0x0001F0FC,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x00022400,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xA0000000,	0x00000000,
		0x0B3, 0x0007C760,
	0xB0000000,	0x00000000,
		0x0B4, 0x00099D40,
		0x0B5, 0x0004103F,
	0x83000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0xA0000000,	0x00000000,
		0x0B6, 0x000187F8,
	0xB0000000,	0x00000000,
		0x0B7, 0x00030018,
		0x0BC, 0x00000008,
		0x0D3, 0x00000542,
		0x0DD, 0x00000500,
		0x0BB, 0x00040010,
		0x0B0, 0x0001F0FA,
		0x0FE, 0x00000000,
		0x0CA, 0x00080000,
		0x0CA, 0x00080001,
		0x0FE, 0x00000000,
		0x0B0, 0x0001F0F8,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xA0000000,	0x00000000,
		0x0B3, 0x0007C700,
	0xB0000000,	0x00000000,
		0x018, 0x0001B124,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xA0000000,	0x00000000,
		0x0B3, 0x0007C760,
	0xB0000000,	0x00000000,
		0x018, 0x00013124,
		0x0CC, 0x0000F000,
		0x0CD, 0x00089600,
		0x018, 0x00013108,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0B8, 0x000C0440,
		0x0BA, 0x000E840D,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x018, 0x00013124,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x059, 0x000A0000,
		0x05A, 0x00060000,
		0x05B, 0x00014000,
		0x0ED, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x0000000F,
		0x0ED, 0x00000000,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0xA0000000,	0x00000000,
		0x0DD, 0x00000500,
	0xB0000000,	0x00000000,
		0x0BC, 0x00000004,
		0x0EE, 0x00000002,
		0x033, 0x00000017,
		0x03F, 0x0000003F,
		0x033, 0x00000018,
		0x03F, 0x0000003F,
		0x033, 0x00000019,
		0x03F, 0x00000000,
		0x033, 0x0000001A,
		0x03F, 0x0000003F,
		0x033, 0x0000001B,
		0x03F, 0x0000003F,
		0x033, 0x0000001C,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
		0x0ED, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x000F45A4,
		0x033, 0x00000001,
		0x03F, 0x000F49A4,
		0x033, 0x00000002,
		0x03F, 0x000F49A4,
		0x033, 0x00000003,
		0x03F, 0x000F69A4,
		0x033, 0x00000004,
		0x03F, 0x000F69A4,
		0x033, 0x00000005,
		0x03F, 0x000F69A4,
		0x033, 0x00000006,
		0x03F, 0x000F6DA4,
		0x033, 0x00000007,
		0x03F, 0x000F6DA4,
		0x033, 0x00000008,
		0x03F, 0x000F6DA4,
		0x033, 0x00000009,
		0x03F, 0x000F8DA4,
		0x033, 0x0000000A,
		0x03F, 0x000F8DA4,
		0x033, 0x0000000B,
		0x03F, 0x000F8DA4,
		0x033, 0x0000000C,
		0x03F, 0x000F91A4,
		0x033, 0x0000000D,
		0x03F, 0x000F91A4,
		0x033, 0x0000000E,
		0x03F, 0x000F91A4,
		0x033, 0x0000000F,
		0x03F, 0x000FB1A4,
		0x033, 0x00000010,
		0x03F, 0x000FB1A4,
		0x033, 0x00000011,
		0x03F, 0x000FB1A4,
		0x033, 0x00000012,
		0x03F, 0x000FB5A4,
		0x033, 0x00000013,
		0x03F, 0x000FB5A4,
		0x033, 0x00000014,
		0x03F, 0x000FD9A4,
		0x033, 0x00000015,
		0x03F, 0x000FD9A4,
		0x033, 0x00000016,
		0x03F, 0x000FF9A4,
		0x033, 0x00000017,
		0x03F, 0x000FF9A4,
		0x033, 0x00000018,
		0x03F, 0x000FFDA4,
		0x033, 0x00000019,
		0x03F, 0x000FFDA4,
		0x033, 0x0000001A,
		0x03F, 0x000FFDA4,
		0x0ED, 0x00000000,
		0x092, 0x00084800,
		0x092, 0x00084801,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x092, 0x00084800,
		0x08F, 0x00001B4C,
		0x088, 0x0004326B,
		0x019, 0x00000005,
		0x0EF, 0x00080000,
		0x033, 0x00000004,
		0x03E, 0x00000003,
		0x03F, 0x000F60FF,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000006,
		0x03E, 0x00000003,
		0x03F, 0x000760FF,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000007,
		0x03E, 0x00000003,
		0x03F, 0x0007DEFF,
		0x0EF, 0x00000000,

};

void
odm_read_and_config_mp_8822c_radioa(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8822c_radioa) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8822c_radioa;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8822c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8822c_radioa(void)
{
		return 53;
}

/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8822c_radiob[] = {
		0x000, 0x00030000,
		0x018, 0x00013124,
		0x093, 0x0008483F,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0xA0000000,	0x00000000,
		0x03F, 0x00091230,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0DE, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000B9140,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000B9140,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0xA0000000,	0x00000000,
		0x08E, 0x000A5540,
	0xB0000000,	0x00000000,
		0x081, 0x0000FC01,
		0x081, 0x0002FC01,
		0x081, 0x0003FC01,
		0x085, 0x0006A06C,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773E8,
		0x033, 0x0000000E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000D,
		0x03F, 0x00000380,
		0x033, 0x0000000C,
		0x03F, 0x000FF380,
		0x033, 0x0000000B,
		0x03F, 0x00000300,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773E8,
		0x033, 0x0000001E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001D,
		0x03F, 0x00000380,
		0x033, 0x0000001C,
		0x03F, 0x000FF380,
		0x033, 0x0000001B,
		0x03F, 0x00000300,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773E8,
		0x033, 0x0000002E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002D,
		0x03F, 0x00000380,
		0x033, 0x0000002C,
		0x03F, 0x000FF380,
		0x033, 0x0000002B,
		0x03F, 0x00000300,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773E8,
		0x033, 0x0000003E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003D,
		0x03F, 0x00000380,
		0x033, 0x0000003C,
		0x03F, 0x000FF380,
		0x033, 0x0000003B,
		0x03F, 0x00000300,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773E8,
		0x033, 0x0000004E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004D,
		0x03F, 0x00000380,
		0x033, 0x0000004C,
		0x03F, 0x000FF380,
		0x033, 0x0000004B,
		0x03F, 0x00000300,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000043,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773E8,
		0x033, 0x0000005E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005D,
		0x03F, 0x00000380,
		0x033, 0x0000005C,
		0x03F, 0x000FF380,
		0x033, 0x0000005B,
		0x03F, 0x00000300,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000053,
		0x03F, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x08A, 0x000E7DE3,
		0x08B, 0x0008FE00,
		0x0EE, 0x00000008,
		0x033, 0x00000000,
		0x03F, 0x00000023,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x0EE, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000010,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
		0x01B, 0x00003A40,
		0x061, 0x0000D233,
		0x062, 0x0004D232,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x063, 0x00000C02,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0xA0000000,	0x00000000,
		0x030, 0x00000233,
		0x030, 0x00001233,
		0x030, 0x00002233,
		0x030, 0x00003233,
		0x030, 0x00004203,
		0x030, 0x00005233,
		0x030, 0x00006233,
		0x030, 0x00007233,
		0x030, 0x00008203,
		0x030, 0x00009233,
		0x030, 0x0000A233,
		0x030, 0x0000B233,
		0x030, 0x0000C233,
		0x030, 0x0000D233,
		0x030, 0x0000E203,
		0x030, 0x0000F233,
		0x030, 0x00010233,
		0x030, 0x00011233,
		0x030, 0x00012203,
		0x030, 0x00013233,
		0x030, 0x00014233,
		0x030, 0x00015233,
		0x030, 0x00016203,
		0x030, 0x00017233,
		0x030, 0x00018203,
		0x030, 0x00019233,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0xA0000000,	0x00000000,
		0x030, 0x00000232,
		0x030, 0x00001232,
		0x030, 0x00002232,
		0x030, 0x00003232,
		0x030, 0x00004232,
		0x030, 0x00005232,
		0x030, 0x00006232,
		0x030, 0x00007232,
		0x030, 0x00008232,
		0x030, 0x00009232,
		0x030, 0x0000A232,
		0x030, 0x0000B232,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000770,
		0x030, 0x00001770,
		0x030, 0x00002440,
		0x030, 0x00003440,
		0x030, 0x00004330,
		0x030, 0x00005330,
		0x030, 0x00008770,
		0x030, 0x0000A440,
		0x030, 0x0000C330,
		0x0EF, 0x00000000,
		0x0EE, 0x00010000,
	0x83000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x83000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x83000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
		0x051, 0x0003C800,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0xA0000000,	0x00000000,
		0x052, 0x000942C0,
	0xB0000000,	0x00000000,
		0x053, 0x000090F9,
		0x054, 0x00088000,
		0x057, 0x0004C80A,
		0x0EF, 0x00000020,
		0x033, 0x00000000,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
		0x03E, 0x00000020,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00010000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000D09,
		0x033, 0x00000064,
		0x03F, 0x00000D49,
		0x033, 0x00000065,
		0x03F, 0x00000D8A,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000487,
		0x033, 0x00000061,
		0x03F, 0x00000887,
		0x033, 0x00000062,
		0x03F, 0x00000947,
		0x033, 0x00000063,
		0x03F, 0x00000D48,
		0x033, 0x00000064,
		0x03F, 0x00000D88,
		0x033, 0x00000065,
		0x03F, 0x00000DE8,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000015,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94000016,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000487,
		0x033, 0x00000021,
		0x03F, 0x00000887,
		0x033, 0x00000022,
		0x03F, 0x00000947,
		0x033, 0x00000023,
		0x03F, 0x00000D48,
		0x033, 0x00000024,
		0x03F, 0x00000D88,
		0x033, 0x00000025,
		0x03F, 0x00000DE8,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x05C, 0x000FC000,
		0x067, 0x0000A505,
		0x0D3, 0x00000542,
		0x043, 0x00005000,
		0x059, 0x000A0000,
		0x05A, 0x00060000,
		0x05B, 0x00014000,
		0x001, 0x00040000,
		0x0EE, 0x00000002,
		0x033, 0x00000017,
		0x03F, 0x0000003F,
		0x033, 0x00000018,
		0x03F, 0x0000003F,
		0x033, 0x00000019,
		0x03F, 0x00000000,
		0x033, 0x0000001A,
		0x03F, 0x0000003F,
		0x033, 0x0000001B,
		0x03F, 0x0000003F,
		0x033, 0x0000001C,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
		0x092, 0x00084800,
		0x092, 0x00084801,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x092, 0x00084800,
		0x08F, 0x00001B4C,
		0x088, 0x0004326B,
		0x019, 0x00000005,
		0x0EF, 0x00080000,
		0x033, 0x00000004,
		0x03F, 0x000FD83F,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000006,
		0x03F, 0x000DD83F,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000007,
		0x03F, 0x000DF7BF,
		0x0EF, 0x00000000,
		0x0EF, 0x00040000,
		0x033, 0x00000006,
		0x03F, 0x00000002,
		0x033, 0x00000007,
		0x03F, 0x00000002,
		0x0EF, 0x00000000,

};

void
odm_read_and_config_mp_8822c_radiob(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8822c_radiob) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8822c_radiob;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_b_8822c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8822c_radiob(void)
{
		return 53;
}

/******************************************************************************
 *                           txpowertrack.TXT
 ******************************************************************************/

#ifdef CONFIG_8822C
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_8822c[][D_S_SIZE] = {
	{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18,
	 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32},
	{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18,
	 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32},
	{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18,
	 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_8822c[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 22, 23, 24, 25, 26, 27},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 22, 23, 24, 25, 26, 27},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 22, 23, 24, 25, 26, 27},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_8822c[][D_S_SIZE] = {
	{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18,
	 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33},
	{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18,
	 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33},
	{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18,
	 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_8822c[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_8822c[]    = {
	0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 15, 15, 16, 17, 18, 19, 20, 20, 21, 22, 23, 24, 25};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_8822c[]    = {
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_8822c[]    = {
	0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_8822c[]    = {
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 26, 27};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8822c[] = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14,
	 15, 16, 17, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8822c[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8822c[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 22};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8822c[] = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14,
	 15, 16, 17, 18, 18, 19, 20, 21, 22, 23, 24, 24, 25};
#endif

void
odm_read_and_config_mp_8822c_txpowertrack(struct dm_struct *dm)
{
#ifdef CONFIG_8822C

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertracktssi.TXT
 ******************************************************************************/

#ifdef CONFIG_8822CTSSI
const u8 delta_swingidx_mp_5gb_n_txpwrtrktssi_8822c[][D_S_SIZE] = {
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrktssi_8822c[][D_S_SIZE] = {
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrktssi_8822c[][D_S_SIZE] = {
	{0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrktssi_8822c[][D_S_SIZE] = {
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrktssi_8822c[]    = {
	0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrktssi_8822c[]    = {
	0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6,
	 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11};
const u8 delta_swingidx_mp_2ga_n_txpwrtrktssi_8822c[]    = {
	0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrktssi_8822c[]    = {
	0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7,
	 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrktssi_8822c[] = {
	0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrktssi_8822c[] = {
	0, 0, 0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5,
	 6, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrktssi_8822c[] = {
	0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7,
	 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrktssi_8822c[] = {
	0, 0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12};
#endif

void
odm_read_and_config_mp_8822c_txpowertracktssi(struct dm_struct *dm)
{
#ifdef CONFIG_8822CTSSI

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

#ifdef CONFIG_8822C
const char *array_mp_8822c_txpwr_lmt[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "72",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "01", "72",
	"KCC", "2.4G", "20M", "CCK", "1T", "01", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "01", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "01", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "01", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "01", "72",
	"CN", "2.4G", "20M", "CCK", "1T", "01", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "72",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "02", "72",
	"KCC", "2.4G", "20M", "CCK", "1T", "02", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "02", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "02", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "02", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "02", "72",
	"CN", "2.4G", "20M", "CCK", "1T", "02", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "03", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "03", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "03", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "03", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "03", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "03", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "03", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "04", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "04", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "04", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "04", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "04", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "04", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "04", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "05", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "05", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "05", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "05", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "05", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "05", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "05", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "06", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "06", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "06", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "06", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "06", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "06", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "06", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "07", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "07", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "07", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "07", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "07", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "07", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "07", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "08", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "08", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "08", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "08", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "08", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "08", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "08", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "09", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "09", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "09", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "09", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "09", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "09", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "09", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "72",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "10", "72",
	"KCC", "2.4G", "20M", "CCK", "1T", "10", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "10", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "10", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "10", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "10", "72",
	"CN", "2.4G", "20M", "CCK", "1T", "10", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "72",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "11", "72",
	"KCC", "2.4G", "20M", "CCK", "1T", "11", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "11", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "11", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "11", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "11", "72",
	"CN", "2.4G", "20M", "CCK", "1T", "11", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "52",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "12", "52",
	"KCC", "2.4G", "20M", "CCK", "1T", "12", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "12", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "12", "52",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "12", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "12", "52",
	"CN", "2.4G", "20M", "CCK", "1T", "12", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "48",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "13", "48",
	"KCC", "2.4G", "20M", "CCK", "1T", "13", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "13", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "13", "48",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "13", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "13", "48",
	"CN", "2.4G", "20M", "CCK", "1T", "13", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "127",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "14", "127",
	"KCC", "2.4G", "20M", "CCK", "1T", "14", "127",
	"ACMA", "2.4G", "20M", "CCK", "1T", "14", "127",
	"CHILE", "2.4G", "20M", "CCK", "1T", "14", "127",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "14", "127",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "14", "127",
	"CN", "2.4G", "20M", "CCK", "1T", "14", "127",
	"FCC", "2.4G", "20M", "CCK", "2T", "01", "72",
	"ETSI", "2.4G", "20M", "CCK", "2T", "01", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "01", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "01", "72",
	"KCC", "2.4G", "20M", "CCK", "2T", "01", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "01", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "01", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "01", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "01", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "01", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "02", "72",
	"ETSI", "2.4G", "20M", "CCK", "2T", "02", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "02", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "02", "72",
	"KCC", "2.4G", "20M", "CCK", "2T", "02", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "02", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "02", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "02", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "02", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "02", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "03", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "03", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "03", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "03", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "03", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "03", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "03", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "03", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "03", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "03", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "04", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "04", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "04", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "04", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "04", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "04", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "04", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "04", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "04", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "04", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "05", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "05", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "05", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "05", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "05", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "05", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "05", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "05", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "05", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "05", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "06", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "06", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "06", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "06", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "06", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "06", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "06", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "06", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "06", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "06", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "07", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "07", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "07", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "07", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "07", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "07", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "07", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "07", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "07", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "07", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "08", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "08", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "08", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "08", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "08", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "08", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "08", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "08", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "08", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "08", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "09", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "09", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "09", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "09", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "09", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "09", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "09", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "09", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "09", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "09", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "10", "72",
	"ETSI", "2.4G", "20M", "CCK", "2T", "10", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "10", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "10", "72",
	"KCC", "2.4G", "20M", "CCK", "2T", "10", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "10", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "10", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "10", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "10", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "10", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "11", "72",
	"ETSI", "2.4G", "20M", "CCK", "2T", "11", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "11", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "11", "72",
	"KCC", "2.4G", "20M", "CCK", "2T", "11", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "11", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "11", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "11", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "11", "60",
	"CN", "2.4G", "20M", "CCK", "2T", "11", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "12", "52",
	"ETSI", "2.4G", "20M", "CCK", "2T", "12", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "12", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "12", "52",
	"KCC", "2.4G", "20M", "CCK", "2T", "12", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "12", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "12", "52",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "12", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "12", "52",
	"CN", "2.4G", "20M", "CCK", "2T", "12", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "13", "36",
	"ETSI", "2.4G", "20M", "CCK", "2T", "13", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "13", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "13", "36",
	"KCC", "2.4G", "20M", "CCK", "2T", "13", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "13", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "13", "36",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "13", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "13", "36",
	"CN", "2.4G", "20M", "CCK", "2T", "13", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "14", "127",
	"ETSI", "2.4G", "20M", "CCK", "2T", "14", "127",
	"MKK", "2.4G", "20M", "CCK", "2T", "14", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "14", "127",
	"KCC", "2.4G", "20M", "CCK", "2T", "14", "127",
	"ACMA", "2.4G", "20M", "CCK", "2T", "14", "127",
	"CHILE", "2.4G", "20M", "CCK", "2T", "14", "127",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "14", "127",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "14", "127",
	"CN", "2.4G", "20M", "CCK", "2T", "14", "127",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "52",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "01", "52",
	"KCC", "2.4G", "20M", "OFDM", "1T", "01", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "01", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "01", "52",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "01", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "01", "52",
	"CN", "2.4G", "20M", "OFDM", "1T", "01", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"KCC", "2.4G", "20M", "OFDM", "1T", "02", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"CN", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"KCC", "2.4G", "20M", "OFDM", "1T", "03", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "03", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "03", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"CN", "2.4G", "20M", "OFDM", "1T", "03", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "68",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "04", "68",
	"KCC", "2.4G", "20M", "OFDM", "1T", "04", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "04", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "04", "68",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "04", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "04", "68",
	"CN", "2.4G", "20M", "OFDM", "1T", "04", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"KCC", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "05", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "05", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"CN", "2.4G", "20M", "OFDM", "1T", "05", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"KCC", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "06", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "06", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"CN", "2.4G", "20M", "OFDM", "1T", "06", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"KCC", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "07", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "07", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"CN", "2.4G", "20M", "OFDM", "1T", "07", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "68",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "08", "68",
	"KCC", "2.4G", "20M", "OFDM", "1T", "08", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "08", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "08", "68",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "08", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "08", "68",
	"CN", "2.4G", "20M", "OFDM", "1T", "08", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"KCC", "2.4G", "20M", "OFDM", "1T", "09", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "09", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "09", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"CN", "2.4G", "20M", "OFDM", "1T", "09", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"KCC", "2.4G", "20M", "OFDM", "1T", "10", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"CN", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"KCC", "2.4G", "20M", "OFDM", "1T", "11", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "11", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "11", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"CN", "2.4G", "20M", "OFDM", "1T", "11", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"KCC", "2.4G", "20M", "OFDM", "1T", "12", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "12", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "12", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"CN", "2.4G", "20M", "OFDM", "1T", "12", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "13", "28",
	"KCC", "2.4G", "20M", "OFDM", "1T", "13", "70",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "13", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "13", "28",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "13", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "13", "28",
	"CN", "2.4G", "20M", "OFDM", "1T", "13", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"IC", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"KCC", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"CN", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"FCC", "2.4G", "20M", "OFDM", "2T", "01", "52",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "01", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "01", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "01", "52",
	"KCC", "2.4G", "20M", "OFDM", "2T", "01", "68",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "01", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "01", "52",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "01", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "01", "52",
	"CN", "2.4G", "20M", "OFDM", "2T", "01", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "02", "60",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "02", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "02", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "02", "60",
	"KCC", "2.4G", "20M", "OFDM", "2T", "02", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "02", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "02", "60",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "02", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "02", "60",
	"CN", "2.4G", "20M", "OFDM", "2T", "02", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "03", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"KCC", "2.4G", "20M", "OFDM", "2T", "03", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "03", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "03", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"CN", "2.4G", "20M", "OFDM", "2T", "03", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "04", "68",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "04", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "04", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "04", "68",
	"KCC", "2.4G", "20M", "OFDM", "2T", "04", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "04", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "04", "68",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "04", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "04", "68",
	"CN", "2.4G", "20M", "OFDM", "2T", "04", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "05", "76",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "05", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "05", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "05", "76",
	"KCC", "2.4G", "20M", "OFDM", "2T", "05", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "05", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "05", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "05", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "05", "76",
	"CN", "2.4G", "20M", "OFDM", "2T", "05", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "06", "76",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "06", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "06", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "06", "76",
	"KCC", "2.4G", "20M", "OFDM", "2T", "06", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "06", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "06", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "06", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "06", "76",
	"CN", "2.4G", "20M", "OFDM", "2T", "06", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "07", "76",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "07", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "07", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "07", "76",
	"KCC", "2.4G", "20M", "OFDM", "2T", "07", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "07", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "07", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "07", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "07", "76",
	"CN", "2.4G", "20M", "OFDM", "2T", "07", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "08", "68",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "08", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "08", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "08", "68",
	"KCC", "2.4G", "20M", "OFDM", "2T", "08", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "08", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "08", "68",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "08", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "08", "68",
	"CN", "2.4G", "20M", "OFDM", "2T", "08", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "09", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"KCC", "2.4G", "20M", "OFDM", "2T", "09", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "09", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "09", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"CN", "2.4G", "20M", "OFDM", "2T", "09", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "10", "60",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "10", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "10", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "10", "60",
	"KCC", "2.4G", "20M", "OFDM", "2T", "10", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "10", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "10", "60",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "10", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "10", "60",
	"CN", "2.4G", "20M", "OFDM", "2T", "10", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "11", "52",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "11", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "11", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "11", "52",
	"KCC", "2.4G", "20M", "OFDM", "2T", "11", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "11", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "11", "52",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "11", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "11", "52",
	"CN", "2.4G", "20M", "OFDM", "2T", "11", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "12", "40",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "12", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "12", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "12", "40",
	"KCC", "2.4G", "20M", "OFDM", "2T", "12", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "12", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "12", "40",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "12", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "12", "40",
	"CN", "2.4G", "20M", "OFDM", "2T", "12", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "13", "28",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "13", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "13", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "13", "28",
	"KCC", "2.4G", "20M", "OFDM", "2T", "13", "62",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "13", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "13", "28",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "13", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "13", "28",
	"CN", "2.4G", "20M", "OFDM", "2T", "13", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"MKK", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"IC", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"KCC", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"CN", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "52",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "76",
	"IC", "2.4G", "20M", "HT", "1T", "01", "52",
	"KCC", "2.4G", "20M", "HT", "1T", "01", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "01", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "01", "52",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "01", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "01", "52",
	"CN", "2.4G", "20M", "HT", "1T", "01", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "60",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "76",
	"IC", "2.4G", "20M", "HT", "1T", "02", "60",
	"KCC", "2.4G", "20M", "HT", "1T", "02", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "02", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "02", "60",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "02", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "02", "60",
	"CN", "2.4G", "20M", "HT", "1T", "02", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "64",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "76",
	"IC", "2.4G", "20M", "HT", "1T", "03", "64",
	"KCC", "2.4G", "20M", "HT", "1T", "03", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "03", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "03", "64",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "03", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "03", "64",
	"CN", "2.4G", "20M", "HT", "1T", "03", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "68",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "76",
	"IC", "2.4G", "20M", "HT", "1T", "04", "68",
	"KCC", "2.4G", "20M", "HT", "1T", "04", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "04", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "04", "68",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "04", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "04", "68",
	"CN", "2.4G", "20M", "HT", "1T", "04", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "76",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "76",
	"IC", "2.4G", "20M", "HT", "1T", "05", "76",
	"KCC", "2.4G", "20M", "HT", "1T", "05", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "05", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "05", "76",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "05", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "05", "76",
	"CN", "2.4G", "20M", "HT", "1T", "05", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "76",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "76",
	"IC", "2.4G", "20M", "HT", "1T", "06", "76",
	"KCC", "2.4G", "20M", "HT", "1T", "06", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "06", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "06", "76",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "06", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "06", "76",
	"CN", "2.4G", "20M", "HT", "1T", "06", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "76",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "76",
	"IC", "2.4G", "20M", "HT", "1T", "07", "76",
	"KCC", "2.4G", "20M", "HT", "1T", "07", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "07", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "07", "76",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "07", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "07", "76",
	"CN", "2.4G", "20M", "HT", "1T", "07", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "68",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "76",
	"IC", "2.4G", "20M", "HT", "1T", "08", "68",
	"KCC", "2.4G", "20M", "HT", "1T", "08", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "08", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "08", "68",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "08", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "08", "68",
	"CN", "2.4G", "20M", "HT", "1T", "08", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "64",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "76",
	"IC", "2.4G", "20M", "HT", "1T", "09", "64",
	"KCC", "2.4G", "20M", "HT", "1T", "09", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "09", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "09", "64",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "09", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "09", "64",
	"CN", "2.4G", "20M", "HT", "1T", "09", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "60",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "76",
	"IC", "2.4G", "20M", "HT", "1T", "10", "60",
	"KCC", "2.4G", "20M", "HT", "1T", "10", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "10", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "10", "60",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "10", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "10", "60",
	"CN", "2.4G", "20M", "HT", "1T", "10", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "52",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "76",
	"IC", "2.4G", "20M", "HT", "1T", "11", "52",
	"KCC", "2.4G", "20M", "HT", "1T", "11", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "11", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "11", "52",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "11", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "11", "52",
	"CN", "2.4G", "20M", "HT", "1T", "11", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "76",
	"IC", "2.4G", "20M", "HT", "1T", "12", "40",
	"KCC", "2.4G", "20M", "HT", "1T", "12", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "12", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "12", "40",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "12", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "12", "40",
	"CN", "2.4G", "20M", "HT", "1T", "12", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "28",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "76",
	"IC", "2.4G", "20M", "HT", "1T", "13", "28",
	"KCC", "2.4G", "20M", "HT", "1T", "13", "72",
	"ACMA", "2.4G", "20M", "HT", "1T", "13", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "13", "28",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "13", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "13", "28",
	"CN", "2.4G", "20M", "HT", "1T", "13", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "127",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "127",
	"IC", "2.4G", "20M", "HT", "1T", "14", "127",
	"KCC", "2.4G", "20M", "HT", "1T", "14", "127",
	"ACMA", "2.4G", "20M", "HT", "1T", "14", "127",
	"CHILE", "2.4G", "20M", "HT", "1T", "14", "127",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "14", "127",
	"MEXICO", "2.4G", "20M", "HT", "1T", "14", "127",
	"CN", "2.4G", "20M", "HT", "1T", "14", "127",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "52",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "66",
	"IC", "2.4G", "20M", "HT", "2T", "01", "52",
	"KCC", "2.4G", "20M", "HT", "2T", "01", "68",
	"ACMA", "2.4G", "20M", "HT", "2T", "01", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "01", "52",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "01", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "01", "52",
	"CN", "2.4G", "20M", "HT", "2T", "01", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "60",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "66",
	"IC", "2.4G", "20M", "HT", "2T", "02", "60",
	"KCC", "2.4G", "20M", "HT", "2T", "02", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "02", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "02", "60",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "02", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "02", "60",
	"CN", "2.4G", "20M", "HT", "2T", "02", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "64",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "66",
	"IC", "2.4G", "20M", "HT", "2T", "03", "64",
	"KCC", "2.4G", "20M", "HT", "2T", "03", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "03", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "03", "64",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "03", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "03", "64",
	"CN", "2.4G", "20M", "HT", "2T", "03", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "68",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "66",
	"IC", "2.4G", "20M", "HT", "2T", "04", "68",
	"KCC", "2.4G", "20M", "HT", "2T", "04", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "04", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "04", "68",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "04", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "04", "68",
	"CN", "2.4G", "20M", "HT", "2T", "04", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "76",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "66",
	"IC", "2.4G", "20M", "HT", "2T", "05", "76",
	"KCC", "2.4G", "20M", "HT", "2T", "05", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "05", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "05", "76",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "05", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "05", "76",
	"CN", "2.4G", "20M", "HT", "2T", "05", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "76",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "66",
	"IC", "2.4G", "20M", "HT", "2T", "06", "76",
	"KCC", "2.4G", "20M", "HT", "2T", "06", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "06", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "06", "76",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "06", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "06", "76",
	"CN", "2.4G", "20M", "HT", "2T", "06", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "76",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "66",
	"IC", "2.4G", "20M", "HT", "2T", "07", "76",
	"KCC", "2.4G", "20M", "HT", "2T", "07", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "07", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "07", "76",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "07", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "07", "76",
	"CN", "2.4G", "20M", "HT", "2T", "07", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "68",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "66",
	"IC", "2.4G", "20M", "HT", "2T", "08", "68",
	"KCC", "2.4G", "20M", "HT", "2T", "08", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "08", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "08", "68",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "08", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "08", "68",
	"CN", "2.4G", "20M", "HT", "2T", "08", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "64",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "66",
	"IC", "2.4G", "20M", "HT", "2T", "09", "64",
	"KCC", "2.4G", "20M", "HT", "2T", "09", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "09", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "09", "64",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "09", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "09", "64",
	"CN", "2.4G", "20M", "HT", "2T", "09", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "60",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "66",
	"IC", "2.4G", "20M", "HT", "2T", "10", "60",
	"KCC", "2.4G", "20M", "HT", "2T", "10", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "10", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "10", "60",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "10", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "10", "60",
	"CN", "2.4G", "20M", "HT", "2T", "10", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "52",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "66",
	"IC", "2.4G", "20M", "HT", "2T", "11", "52",
	"KCC", "2.4G", "20M", "HT", "2T", "11", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "11", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "11", "52",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "11", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "11", "52",
	"CN", "2.4G", "20M", "HT", "2T", "11", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "40",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "66",
	"IC", "2.4G", "20M", "HT", "2T", "12", "40",
	"KCC", "2.4G", "20M", "HT", "2T", "12", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "12", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "12", "40",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "12", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "12", "40",
	"CN", "2.4G", "20M", "HT", "2T", "12", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "66",
	"IC", "2.4G", "20M", "HT", "2T", "13", "28",
	"KCC", "2.4G", "20M", "HT", "2T", "13", "62",
	"ACMA", "2.4G", "20M", "HT", "2T", "13", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "13", "28",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "13", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "13", "28",
	"CN", "2.4G", "20M", "HT", "2T", "13", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "127",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "127",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "127",
	"IC", "2.4G", "20M", "HT", "2T", "14", "127",
	"KCC", "2.4G", "20M", "HT", "2T", "14", "127",
	"ACMA", "2.4G", "20M", "HT", "2T", "14", "127",
	"CHILE", "2.4G", "20M", "HT", "2T", "14", "127",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "14", "127",
	"MEXICO", "2.4G", "20M", "HT", "2T", "14", "127",
	"CN", "2.4G", "20M", "HT", "2T", "14", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "127",
	"IC", "2.4G", "40M", "HT", "1T", "01", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "01", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "01", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "01", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "01", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "01", "127",
	"CN", "2.4G", "40M", "HT", "1T", "01", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "127",
	"IC", "2.4G", "40M", "HT", "1T", "02", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "02", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "02", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "02", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "02", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "02", "127",
	"CN", "2.4G", "40M", "HT", "1T", "02", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "52",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "72",
	"IC", "2.4G", "40M", "HT", "1T", "03", "52",
	"KCC", "2.4G", "40M", "HT", "1T", "03", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "03", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "03", "52",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "03", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "03", "52",
	"CN", "2.4G", "40M", "HT", "1T", "03", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "52",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "72",
	"IC", "2.4G", "40M", "HT", "1T", "04", "52",
	"KCC", "2.4G", "40M", "HT", "1T", "04", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "04", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "04", "52",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "04", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "04", "52",
	"CN", "2.4G", "40M", "HT", "1T", "04", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "60",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "72",
	"IC", "2.4G", "40M", "HT", "1T", "05", "60",
	"KCC", "2.4G", "40M", "HT", "1T", "05", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "05", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "05", "60",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "05", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "05", "60",
	"CN", "2.4G", "40M", "HT", "1T", "05", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "64",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "72",
	"IC", "2.4G", "40M", "HT", "1T", "06", "64",
	"KCC", "2.4G", "40M", "HT", "1T", "06", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "06", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "06", "64",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "06", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "06", "64",
	"CN", "2.4G", "40M", "HT", "1T", "06", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "60",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "72",
	"IC", "2.4G", "40M", "HT", "1T", "07", "60",
	"KCC", "2.4G", "40M", "HT", "1T", "07", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "07", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "07", "60",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "07", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "07", "60",
	"CN", "2.4G", "40M", "HT", "1T", "07", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "52",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "72",
	"IC", "2.4G", "40M", "HT", "1T", "08", "52",
	"KCC", "2.4G", "40M", "HT", "1T", "08", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "08", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "08", "52",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "08", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "08", "52",
	"CN", "2.4G", "40M", "HT", "1T", "08", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "52",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "72",
	"IC", "2.4G", "40M", "HT", "1T", "09", "52",
	"KCC", "2.4G", "40M", "HT", "1T", "09", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "09", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "09", "52",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "09", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "09", "52",
	"CN", "2.4G", "40M", "HT", "1T", "09", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "40",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "72",
	"IC", "2.4G", "40M", "HT", "1T", "10", "40",
	"KCC", "2.4G", "40M", "HT", "1T", "10", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "10", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "10", "40",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "10", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "10", "40",
	"CN", "2.4G", "40M", "HT", "1T", "10", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "28",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "72",
	"IC", "2.4G", "40M", "HT", "1T", "11", "28",
	"KCC", "2.4G", "40M", "HT", "1T", "11", "70",
	"ACMA", "2.4G", "40M", "HT", "1T", "11", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "11", "28",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "11", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "11", "28",
	"CN", "2.4G", "40M", "HT", "1T", "11", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "127",
	"IC", "2.4G", "40M", "HT", "1T", "12", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "12", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "12", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "12", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "12", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "12", "127",
	"CN", "2.4G", "40M", "HT", "1T", "12", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "127",
	"IC", "2.4G", "40M", "HT", "1T", "13", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "13", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "13", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "13", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "13", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "13", "127",
	"CN", "2.4G", "40M", "HT", "1T", "13", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "127",
	"IC", "2.4G", "40M", "HT", "1T", "14", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "14", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "14", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "14", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "14", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "14", "127",
	"CN", "2.4G", "40M", "HT", "1T", "14", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "127",
	"IC", "2.4G", "40M", "HT", "2T", "01", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "01", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "01", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "01", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "01", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "01", "127",
	"CN", "2.4G", "40M", "HT", "2T", "01", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "127",
	"IC", "2.4G", "40M", "HT", "2T", "02", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "02", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "02", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "02", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "02", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "02", "127",
	"CN", "2.4G", "40M", "HT", "2T", "02", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "48",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "66",
	"IC", "2.4G", "40M", "HT", "2T", "03", "48",
	"KCC", "2.4G", "40M", "HT", "2T", "03", "66",
	"ACMA", "2.4G", "40M", "HT", "2T", "03", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "03", "48",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "03", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "03", "48",
	"CN", "2.4G", "40M", "HT", "2T", "03", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "48",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "66",
	"IC", "2.4G", "40M", "HT", "2T", "04", "48",
	"KCC", "2.4G", "40M", "HT", "2T", "04", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "04", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "04", "48",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "04", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "04", "48",
	"CN", "2.4G", "40M", "HT", "2T", "04", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "60",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "66",
	"IC", "2.4G", "40M", "HT", "2T", "05", "60",
	"KCC", "2.4G", "40M", "HT", "2T", "05", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "05", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "05", "60",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "05", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "05", "60",
	"CN", "2.4G", "40M", "HT", "2T", "05", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "64",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "66",
	"IC", "2.4G", "40M", "HT", "2T", "06", "64",
	"KCC", "2.4G", "40M", "HT", "2T", "06", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "06", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "06", "64",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "06", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "06", "64",
	"CN", "2.4G", "40M", "HT", "2T", "06", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "60",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "66",
	"IC", "2.4G", "40M", "HT", "2T", "07", "60",
	"KCC", "2.4G", "40M", "HT", "2T", "07", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "07", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "07", "60",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "07", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "07", "60",
	"CN", "2.4G", "40M", "HT", "2T", "07", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "52",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "66",
	"IC", "2.4G", "40M", "HT", "2T", "08", "52",
	"KCC", "2.4G", "40M", "HT", "2T", "08", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "08", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "08", "52",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "08", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "08", "52",
	"CN", "2.4G", "40M", "HT", "2T", "08", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "52",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "66",
	"IC", "2.4G", "40M", "HT", "2T", "09", "52",
	"KCC", "2.4G", "40M", "HT", "2T", "09", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "09", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "09", "52",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "09", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "09", "52",
	"CN", "2.4G", "40M", "HT", "2T", "09", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "40",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "66",
	"IC", "2.4G", "40M", "HT", "2T", "10", "40",
	"KCC", "2.4G", "40M", "HT", "2T", "10", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "10", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "10", "40",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "10", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "10", "40",
	"CN", "2.4G", "40M", "HT", "2T", "10", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "66",
	"IC", "2.4G", "40M", "HT", "2T", "11", "26",
	"KCC", "2.4G", "40M", "HT", "2T", "11", "66",
	"ACMA", "2.4G", "40M", "HT", "2T", "11", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "11", "26",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "11", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "11", "26",
	"CN", "2.4G", "40M", "HT", "2T", "11", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "127",
	"IC", "2.4G", "40M", "HT", "2T", "12", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "12", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "12", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "12", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "12", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "12", "127",
	"CN", "2.4G", "40M", "HT", "2T", "12", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "127",
	"IC", "2.4G", "40M", "HT", "2T", "13", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "13", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "13", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "13", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "13", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "13", "127",
	"CN", "2.4G", "40M", "HT", "2T", "13", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "127",
	"IC", "2.4G", "40M", "HT", "2T", "14", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "14", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "14", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "14", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "14", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "14", "127",
	"CN", "2.4G", "40M", "HT", "2T", "14", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "74",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "60",
	"IC", "5G", "20M", "OFDM", "1T", "36", "62",
	"KCC", "5G", "20M", "OFDM", "1T", "36", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "36", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "36", "64",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "36", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "36", "62",
	"CN", "5G", "20M", "OFDM", "1T", "36", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "62",
	"IC", "5G", "20M", "OFDM", "1T", "40", "62",
	"KCC", "5G", "20M", "OFDM", "1T", "40", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "40", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "40", "64",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "40", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "40", "62",
	"CN", "5G", "20M", "OFDM", "1T", "40", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "62",
	"IC", "5G", "20M", "OFDM", "1T", "44", "62",
	"KCC", "5G", "20M", "OFDM", "1T", "44", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "44", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "44", "64",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "44", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "44", "62",
	"CN", "5G", "20M", "OFDM", "1T", "44", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "62",
	"IC", "5G", "20M", "OFDM", "1T", "48", "62",
	"KCC", "5G", "20M", "OFDM", "1T", "48", "54",
	"ACMA", "5G", "20M", "OFDM", "1T", "48", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "48", "64",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "48", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "48", "62",
	"CN", "5G", "20M", "OFDM", "1T", "48", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "62",
	"IC", "5G", "20M", "OFDM", "1T", "52", "64",
	"KCC", "5G", "20M", "OFDM", "1T", "52", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "52", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "52", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "52", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "52", "76",
	"CN", "5G", "20M", "OFDM", "1T", "52", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "62",
	"IC", "5G", "20M", "OFDM", "1T", "56", "64",
	"KCC", "5G", "20M", "OFDM", "1T", "56", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "56", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "56", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "56", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "56", "76",
	"CN", "5G", "20M", "OFDM", "1T", "56", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "62",
	"IC", "5G", "20M", "OFDM", "1T", "60", "64",
	"KCC", "5G", "20M", "OFDM", "1T", "60", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "60", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "60", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "60", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "60", "76",
	"CN", "5G", "20M", "OFDM", "1T", "60", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "74",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "60",
	"IC", "5G", "20M", "OFDM", "1T", "64", "64",
	"KCC", "5G", "20M", "OFDM", "1T", "64", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "64", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "64", "74",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "64", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "64", "74",
	"CN", "5G", "20M", "OFDM", "1T", "64", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "72",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "76",
	"IC", "5G", "20M", "OFDM", "1T", "100", "72",
	"KCC", "5G", "20M", "OFDM", "1T", "100", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "100", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "100", "72",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "100", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "100", "72",
	"CN", "5G", "20M", "OFDM", "1T", "100", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "76",
	"IC", "5G", "20M", "OFDM", "1T", "104", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "104", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "104", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "104", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "104", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "104", "76",
	"CN", "5G", "20M", "OFDM", "1T", "104", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "76",
	"IC", "5G", "20M", "OFDM", "1T", "108", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "108", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "108", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "108", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "108", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "108", "76",
	"CN", "5G", "20M", "OFDM", "1T", "108", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "76",
	"IC", "5G", "20M", "OFDM", "1T", "112", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "112", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "112", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "112", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "112", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "112", "76",
	"CN", "5G", "20M", "OFDM", "1T", "112", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "76",
	"IC", "5G", "20M", "OFDM", "1T", "116", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "116", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "116", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "116", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "116", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "116", "76",
	"CN", "5G", "20M", "OFDM", "1T", "116", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "76",
	"IC", "5G", "20M", "OFDM", "1T", "120", "127",
	"KCC", "5G", "20M", "OFDM", "1T", "120", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "120", "127",
	"CHILE", "5G", "20M", "OFDM", "1T", "120", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "120", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "120", "76",
	"CN", "5G", "20M", "OFDM", "1T", "120", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "76",
	"IC", "5G", "20M", "OFDM", "1T", "124", "127",
	"KCC", "5G", "20M", "OFDM", "1T", "124", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "124", "127",
	"CHILE", "5G", "20M", "OFDM", "1T", "124", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "124", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "124", "76",
	"CN", "5G", "20M", "OFDM", "1T", "124", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "76",
	"IC", "5G", "20M", "OFDM", "1T", "128", "127",
	"KCC", "5G", "20M", "OFDM", "1T", "128", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "128", "127",
	"CHILE", "5G", "20M", "OFDM", "1T", "128", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "128", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "128", "76",
	"CN", "5G", "20M", "OFDM", "1T", "128", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "76",
	"IC", "5G", "20M", "OFDM", "1T", "132", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "132", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "132", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "132", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "132", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "132", "76",
	"CN", "5G", "20M", "OFDM", "1T", "132", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "76",
	"IC", "5G", "20M", "OFDM", "1T", "136", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "136", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "136", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "136", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "136", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "136", "76",
	"CN", "5G", "20M", "OFDM", "1T", "136", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "72",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "76",
	"IC", "5G", "20M", "OFDM", "1T", "140", "72",
	"KCC", "5G", "20M", "OFDM", "1T", "140", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "140", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "140", "72",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "140", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "140", "72",
	"CN", "5G", "20M", "OFDM", "1T", "140", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "127",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "127",
	"IC", "5G", "20M", "OFDM", "1T", "144", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "144", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "144", "127",
	"CHILE", "5G", "20M", "OFDM", "1T", "144", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "144", "127",
	"MEXICO", "5G", "20M", "OFDM", "1T", "144", "76",
	"CN", "5G", "20M", "OFDM", "1T", "144", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "127",
	"IC", "5G", "20M", "OFDM", "1T", "149", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "149", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "149", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "149", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "149", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "149", "76",
	"CN", "5G", "20M", "OFDM", "1T", "149", "-128",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "127",
	"IC", "5G", "20M", "OFDM", "1T", "153", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "153", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "153", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "153", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "153", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "153", "76",
	"CN", "5G", "20M", "OFDM", "1T", "153", "-128",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "127",
	"IC", "5G", "20M", "OFDM", "1T", "157", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "157", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "157", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "157", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "157", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "157", "76",
	"CN", "5G", "20M", "OFDM", "1T", "157", "-128",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "127",
	"IC", "5G", "20M", "OFDM", "1T", "161", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "161", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "161", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "161", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "161", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "161", "76",
	"CN", "5G", "20M", "OFDM", "1T", "161", "-128",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "127",
	"IC", "5G", "20M", "OFDM", "1T", "165", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "165", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "165", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "165", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "165", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "165", "76",
	"CN", "5G", "20M", "OFDM", "1T", "165", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "36", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "36", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "36", "48",
	"IC", "5G", "20M", "OFDM", "2T", "36", "40",
	"KCC", "5G", "20M", "OFDM", "2T", "36", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "36", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "36", "52",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "36", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "36", "50",
	"CN", "5G", "20M", "OFDM", "2T", "36", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "40", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "40", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "40", "50",
	"IC", "5G", "20M", "OFDM", "2T", "40", "40",
	"KCC", "5G", "20M", "OFDM", "2T", "40", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "40", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "40", "52",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "40", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "40", "50",
	"CN", "5G", "20M", "OFDM", "2T", "40", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "44", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "44", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "44", "50",
	"IC", "5G", "20M", "OFDM", "2T", "44", "40",
	"KCC", "5G", "20M", "OFDM", "2T", "44", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "44", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "44", "52",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "44", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "44", "50",
	"CN", "5G", "20M", "OFDM", "2T", "44", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "48", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "48", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "48", "50",
	"IC", "5G", "20M", "OFDM", "2T", "48", "40",
	"KCC", "5G", "20M", "OFDM", "2T", "48", "36",
	"ACMA", "5G", "20M", "OFDM", "2T", "48", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "48", "52",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "48", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "48", "50",
	"CN", "5G", "20M", "OFDM", "2T", "48", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "52", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "52", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "52", "50",
	"IC", "5G", "20M", "OFDM", "2T", "52", "52",
	"KCC", "5G", "20M", "OFDM", "2T", "52", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "52", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "52", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "52", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "52", "68",
	"CN", "5G", "20M", "OFDM", "2T", "52", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "56", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "56", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "56", "50",
	"IC", "5G", "20M", "OFDM", "2T", "56", "52",
	"KCC", "5G", "20M", "OFDM", "2T", "56", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "56", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "56", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "56", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "56", "68",
	"CN", "5G", "20M", "OFDM", "2T", "56", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "60", "66",
	"ETSI", "5G", "20M", "OFDM", "2T", "60", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "60", "50",
	"IC", "5G", "20M", "OFDM", "2T", "60", "52",
	"KCC", "5G", "20M", "OFDM", "2T", "60", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "60", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "60", "66",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "60", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "60", "66",
	"CN", "5G", "20M", "OFDM", "2T", "60", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "64", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "64", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "64", "48",
	"IC", "5G", "20M", "OFDM", "2T", "64", "52",
	"KCC", "5G", "20M", "OFDM", "2T", "64", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "64", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "64", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "64", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "64", "68",
	"CN", "5G", "20M", "OFDM", "2T", "64", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "100", "60",
	"ETSI", "5G", "20M", "OFDM", "2T", "100", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "100", "70",
	"IC", "5G", "20M", "OFDM", "2T", "100", "60",
	"KCC", "5G", "20M", "OFDM", "2T", "100", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "100", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "100", "60",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "100", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "100", "60",
	"CN", "5G", "20M", "OFDM", "2T", "100", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "104", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "104", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "104", "70",
	"IC", "5G", "20M", "OFDM", "2T", "104", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "104", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "104", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "104", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "104", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "104", "68",
	"CN", "5G", "20M", "OFDM", "2T", "104", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "108", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "108", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "108", "70",
	"IC", "5G", "20M", "OFDM", "2T", "108", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "108", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "108", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "108", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "108", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "108", "68",
	"CN", "5G", "20M", "OFDM", "2T", "108", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "112", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "112", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "112", "70",
	"IC", "5G", "20M", "OFDM", "2T", "112", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "112", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "112", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "112", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "112", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "112", "68",
	"CN", "5G", "20M", "OFDM", "2T", "112", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "116", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "116", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "116", "70",
	"IC", "5G", "20M", "OFDM", "2T", "116", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "116", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "116", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "116", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "116", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "116", "68",
	"CN", "5G", "20M", "OFDM", "2T", "116", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "120", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "120", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "120", "70",
	"IC", "5G", "20M", "OFDM", "2T", "120", "127",
	"KCC", "5G", "20M", "OFDM", "2T", "120", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "120", "127",
	"CHILE", "5G", "20M", "OFDM", "2T", "120", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "120", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "120", "68",
	"CN", "5G", "20M", "OFDM", "2T", "120", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "124", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "124", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "124", "70",
	"IC", "5G", "20M", "OFDM", "2T", "124", "127",
	"KCC", "5G", "20M", "OFDM", "2T", "124", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "124", "127",
	"CHILE", "5G", "20M", "OFDM", "2T", "124", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "124", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "124", "68",
	"CN", "5G", "20M", "OFDM", "2T", "124", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "128", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "128", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "128", "70",
	"IC", "5G", "20M", "OFDM", "2T", "128", "127",
	"KCC", "5G", "20M", "OFDM", "2T", "128", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "128", "127",
	"CHILE", "5G", "20M", "OFDM", "2T", "128", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "128", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "128", "68",
	"CN", "5G", "20M", "OFDM", "2T", "128", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "132", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "132", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "132", "70",
	"IC", "5G", "20M", "OFDM", "2T", "132", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "132", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "132", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "132", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "132", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "132", "68",
	"CN", "5G", "20M", "OFDM", "2T", "132", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "136", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "136", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "136", "70",
	"IC", "5G", "20M", "OFDM", "2T", "136", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "136", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "136", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "136", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "136", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "136", "68",
	"CN", "5G", "20M", "OFDM", "2T", "136", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "140", "60",
	"ETSI", "5G", "20M", "OFDM", "2T", "140", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "140", "70",
	"IC", "5G", "20M", "OFDM", "2T", "140", "60",
	"KCC", "5G", "20M", "OFDM", "2T", "140", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "140", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "140", "60",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "140", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "140", "60",
	"CN", "5G", "20M", "OFDM", "2T", "140", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "144", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "144", "127",
	"MKK", "5G", "20M", "OFDM", "2T", "144", "127",
	"IC", "5G", "20M", "OFDM", "2T", "144", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "144", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "144", "127",
	"CHILE", "5G", "20M", "OFDM", "2T", "144", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "144", "127",
	"MEXICO", "5G", "20M", "OFDM", "2T", "144", "68",
	"CN", "5G", "20M", "OFDM", "2T", "144", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "149", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "149", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "149", "127",
	"IC", "5G", "20M", "OFDM", "2T", "149", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "149", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "149", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "149", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "149", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "149", "72",
	"CN", "5G", "20M", "OFDM", "2T", "149", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "153", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "153", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "153", "127",
	"IC", "5G", "20M", "OFDM", "2T", "153", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "153", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "153", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "153", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "153", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "153", "76",
	"CN", "5G", "20M", "OFDM", "2T", "153", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "157", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "157", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "157", "127",
	"IC", "5G", "20M", "OFDM", "2T", "157", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "157", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "157", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "157", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "157", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "157", "76",
	"CN", "5G", "20M", "OFDM", "2T", "157", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "161", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "161", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "161", "127",
	"IC", "5G", "20M", "OFDM", "2T", "161", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "161", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "161", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "161", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "161", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "161", "76",
	"CN", "5G", "20M", "OFDM", "2T", "161", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "165", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "165", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "165", "127",
	"IC", "5G", "20M", "OFDM", "2T", "165", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "165", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "165", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "165", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "165", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "165", "76",
	"CN", "5G", "20M", "OFDM", "2T", "165", "-128",
	"FCC", "5G", "20M", "HT", "1T", "36", "72",
	"ETSI", "5G", "20M", "HT", "1T", "36", "62",
	"MKK", "5G", "20M", "HT", "1T", "36", "62",
	"IC", "5G", "20M", "HT", "1T", "36", "62",
	"KCC", "5G", "20M", "HT", "1T", "36", "76",
	"ACMA", "5G", "20M", "HT", "1T", "36", "62",
	"CHILE", "5G", "20M", "HT", "1T", "36", "64",
	"UKRAINE", "5G", "20M", "HT", "1T", "36", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "36", "62",
	"CN", "5G", "20M", "HT", "1T", "36", "62",
	"FCC", "5G", "20M", "HT", "1T", "40", "76",
	"ETSI", "5G", "20M", "HT", "1T", "40", "62",
	"MKK", "5G", "20M", "HT", "1T", "40", "62",
	"IC", "5G", "20M", "HT", "1T", "40", "62",
	"KCC", "5G", "20M", "HT", "1T", "40", "76",
	"ACMA", "5G", "20M", "HT", "1T", "40", "62",
	"CHILE", "5G", "20M", "HT", "1T", "40", "64",
	"UKRAINE", "5G", "20M", "HT", "1T", "40", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "40", "62",
	"CN", "5G", "20M", "HT", "1T", "40", "62",
	"FCC", "5G", "20M", "HT", "1T", "44", "76",
	"ETSI", "5G", "20M", "HT", "1T", "44", "62",
	"MKK", "5G", "20M", "HT", "1T", "44", "62",
	"IC", "5G", "20M", "HT", "1T", "44", "62",
	"KCC", "5G", "20M", "HT", "1T", "44", "76",
	"ACMA", "5G", "20M", "HT", "1T", "44", "62",
	"CHILE", "5G", "20M", "HT", "1T", "44", "64",
	"UKRAINE", "5G", "20M", "HT", "1T", "44", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "44", "62",
	"CN", "5G", "20M", "HT", "1T", "44", "62",
	"FCC", "5G", "20M", "HT", "1T", "48", "76",
	"ETSI", "5G", "20M", "HT", "1T", "48", "62",
	"MKK", "5G", "20M", "HT", "1T", "48", "62",
	"IC", "5G", "20M", "HT", "1T", "48", "62",
	"KCC", "5G", "20M", "HT", "1T", "48", "54",
	"ACMA", "5G", "20M", "HT", "1T", "48", "62",
	"CHILE", "5G", "20M", "HT", "1T", "48", "64",
	"UKRAINE", "5G", "20M", "HT", "1T", "48", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "48", "62",
	"CN", "5G", "20M", "HT", "1T", "48", "62",
	"FCC", "5G", "20M", "HT", "1T", "52", "76",
	"ETSI", "5G", "20M", "HT", "1T", "52", "62",
	"MKK", "5G", "20M", "HT", "1T", "52", "62",
	"IC", "5G", "20M", "HT", "1T", "52", "64",
	"KCC", "5G", "20M", "HT", "1T", "52", "76",
	"ACMA", "5G", "20M", "HT", "1T", "52", "62",
	"CHILE", "5G", "20M", "HT", "1T", "52", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "52", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "52", "76",
	"CN", "5G", "20M", "HT", "1T", "52", "62",
	"FCC", "5G", "20M", "HT", "1T", "56", "76",
	"ETSI", "5G", "20M", "HT", "1T", "56", "62",
	"MKK", "5G", "20M", "HT", "1T", "56", "62",
	"IC", "5G", "20M", "HT", "1T", "56", "64",
	"KCC", "5G", "20M", "HT", "1T", "56", "76",
	"ACMA", "5G", "20M", "HT", "1T", "56", "62",
	"CHILE", "5G", "20M", "HT", "1T", "56", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "56", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "56", "76",
	"CN", "5G", "20M", "HT", "1T", "56", "62",
	"FCC", "5G", "20M", "HT", "1T", "60", "76",
	"ETSI", "5G", "20M", "HT", "1T", "60", "62",
	"MKK", "5G", "20M", "HT", "1T", "60", "62",
	"IC", "5G", "20M", "HT", "1T", "60", "64",
	"KCC", "5G", "20M", "HT", "1T", "60", "76",
	"ACMA", "5G", "20M", "HT", "1T", "60", "62",
	"CHILE", "5G", "20M", "HT", "1T", "60", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "60", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "60", "76",
	"CN", "5G", "20M", "HT", "1T", "60", "62",
	"FCC", "5G", "20M", "HT", "1T", "64", "74",
	"ETSI", "5G", "20M", "HT", "1T", "64", "62",
	"MKK", "5G", "20M", "HT", "1T", "64", "60",
	"IC", "5G", "20M", "HT", "1T", "64", "64",
	"KCC", "5G", "20M", "HT", "1T", "64", "74",
	"ACMA", "5G", "20M", "HT", "1T", "64", "62",
	"CHILE", "5G", "20M", "HT", "1T", "64", "74",
	"UKRAINE", "5G", "20M", "HT", "1T", "64", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "64", "74",
	"CN", "5G", "20M", "HT", "1T", "64", "62",
	"FCC", "5G", "20M", "HT", "1T", "100", "70",
	"ETSI", "5G", "20M", "HT", "1T", "100", "62",
	"MKK", "5G", "20M", "HT", "1T", "100", "76",
	"IC", "5G", "20M", "HT", "1T", "100", "70",
	"KCC", "5G", "20M", "HT", "1T", "100", "76",
	"ACMA", "5G", "20M", "HT", "1T", "100", "62",
	"CHILE", "5G", "20M", "HT", "1T", "100", "70",
	"UKRAINE", "5G", "20M", "HT", "1T", "100", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "100", "70",
	"CN", "5G", "20M", "HT", "1T", "100", "127",
	"FCC", "5G", "20M", "HT", "1T", "104", "76",
	"ETSI", "5G", "20M", "HT", "1T", "104", "62",
	"MKK", "5G", "20M", "HT", "1T", "104", "76",
	"IC", "5G", "20M", "HT", "1T", "104", "76",
	"KCC", "5G", "20M", "HT", "1T", "104", "76",
	"ACMA", "5G", "20M", "HT", "1T", "104", "62",
	"CHILE", "5G", "20M", "HT", "1T", "104", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "104", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "104", "76",
	"CN", "5G", "20M", "HT", "1T", "104", "127",
	"FCC", "5G", "20M", "HT", "1T", "108", "76",
	"ETSI", "5G", "20M", "HT", "1T", "108", "62",
	"MKK", "5G", "20M", "HT", "1T", "108", "76",
	"IC", "5G", "20M", "HT", "1T", "108", "76",
	"KCC", "5G", "20M", "HT", "1T", "108", "76",
	"ACMA", "5G", "20M", "HT", "1T", "108", "62",
	"CHILE", "5G", "20M", "HT", "1T", "108", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "108", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "108", "76",
	"CN", "5G", "20M", "HT", "1T", "108", "127",
	"FCC", "5G", "20M", "HT", "1T", "112", "76",
	"ETSI", "5G", "20M", "HT", "1T", "112", "62",
	"MKK", "5G", "20M", "HT", "1T", "112", "76",
	"IC", "5G", "20M", "HT", "1T", "112", "76",
	"KCC", "5G", "20M", "HT", "1T", "112", "76",
	"ACMA", "5G", "20M", "HT", "1T", "112", "62",
	"CHILE", "5G", "20M", "HT", "1T", "112", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "112", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "112", "76",
	"CN", "5G", "20M", "HT", "1T", "112", "127",
	"FCC", "5G", "20M", "HT", "1T", "116", "76",
	"ETSI", "5G", "20M", "HT", "1T", "116", "62",
	"MKK", "5G", "20M", "HT", "1T", "116", "76",
	"IC", "5G", "20M", "HT", "1T", "116", "76",
	"KCC", "5G", "20M", "HT", "1T", "116", "76",
	"ACMA", "5G", "20M", "HT", "1T", "116", "62",
	"CHILE", "5G", "20M", "HT", "1T", "116", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "116", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "116", "76",
	"CN", "5G", "20M", "HT", "1T", "116", "127",
	"FCC", "5G", "20M", "HT", "1T", "120", "76",
	"ETSI", "5G", "20M", "HT", "1T", "120", "62",
	"MKK", "5G", "20M", "HT", "1T", "120", "76",
	"IC", "5G", "20M", "HT", "1T", "120", "127",
	"KCC", "5G", "20M", "HT", "1T", "120", "76",
	"ACMA", "5G", "20M", "HT", "1T", "120", "127",
	"CHILE", "5G", "20M", "HT", "1T", "120", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "120", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "120", "76",
	"CN", "5G", "20M", "HT", "1T", "120", "127",
	"FCC", "5G", "20M", "HT", "1T", "124", "76",
	"ETSI", "5G", "20M", "HT", "1T", "124", "62",
	"MKK", "5G", "20M", "HT", "1T", "124", "76",
	"IC", "5G", "20M", "HT", "1T", "124", "127",
	"KCC", "5G", "20M", "HT", "1T", "124", "76",
	"ACMA", "5G", "20M", "HT", "1T", "124", "127",
	"CHILE", "5G", "20M", "HT", "1T", "124", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "124", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "124", "76",
	"CN", "5G", "20M", "HT", "1T", "124", "127",
	"FCC", "5G", "20M", "HT", "1T", "128", "76",
	"ETSI", "5G", "20M", "HT", "1T", "128", "62",
	"MKK", "5G", "20M", "HT", "1T", "128", "76",
	"IC", "5G", "20M", "HT", "1T", "128", "127",
	"KCC", "5G", "20M", "HT", "1T", "128", "76",
	"ACMA", "5G", "20M", "HT", "1T", "128", "127",
	"CHILE", "5G", "20M", "HT", "1T", "128", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "128", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "128", "76",
	"CN", "5G", "20M", "HT", "1T", "128", "127",
	"FCC", "5G", "20M", "HT", "1T", "132", "76",
	"ETSI", "5G", "20M", "HT", "1T", "132", "62",
	"MKK", "5G", "20M", "HT", "1T", "132", "76",
	"IC", "5G", "20M", "HT", "1T", "132", "76",
	"KCC", "5G", "20M", "HT", "1T", "132", "76",
	"ACMA", "5G", "20M", "HT", "1T", "132", "62",
	"CHILE", "5G", "20M", "HT", "1T", "132", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "132", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "132", "76",
	"CN", "5G", "20M", "HT", "1T", "132", "127",
	"FCC", "5G", "20M", "HT", "1T", "136", "76",
	"ETSI", "5G", "20M", "HT", "1T", "136", "62",
	"MKK", "5G", "20M", "HT", "1T", "136", "76",
	"IC", "5G", "20M", "HT", "1T", "136", "76",
	"KCC", "5G", "20M", "HT", "1T", "136", "76",
	"ACMA", "5G", "20M", "HT", "1T", "136", "62",
	"CHILE", "5G", "20M", "HT", "1T", "136", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "136", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "136", "76",
	"CN", "5G", "20M", "HT", "1T", "136", "127",
	"FCC", "5G", "20M", "HT", "1T", "140", "70",
	"ETSI", "5G", "20M", "HT", "1T", "140", "62",
	"MKK", "5G", "20M", "HT", "1T", "140", "76",
	"IC", "5G", "20M", "HT", "1T", "140", "70",
	"KCC", "5G", "20M", "HT", "1T", "140", "76",
	"ACMA", "5G", "20M", "HT", "1T", "140", "62",
	"CHILE", "5G", "20M", "HT", "1T", "140", "70",
	"UKRAINE", "5G", "20M", "HT", "1T", "140", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "140", "70",
	"CN", "5G", "20M", "HT", "1T", "140", "127",
	"FCC", "5G", "20M", "HT", "1T", "144", "76",
	"ETSI", "5G", "20M", "HT", "1T", "144", "127",
	"MKK", "5G", "20M", "HT", "1T", "144", "127",
	"IC", "5G", "20M", "HT", "1T", "144", "76",
	"KCC", "5G", "20M", "HT", "1T", "144", "76",
	"ACMA", "5G", "20M", "HT", "1T", "144", "127",
	"CHILE", "5G", "20M", "HT", "1T", "144", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "144", "127",
	"MEXICO", "5G", "20M", "HT", "1T", "144", "76",
	"CN", "5G", "20M", "HT", "1T", "144", "127",
	"FCC", "5G", "20M", "HT", "1T", "149", "76",
	"ETSI", "5G", "20M", "HT", "1T", "149", "-128",
	"MKK", "5G", "20M", "HT", "1T", "149", "127",
	"IC", "5G", "20M", "HT", "1T", "149", "76",
	"KCC", "5G", "20M", "HT", "1T", "149", "74",
	"ACMA", "5G", "20M", "HT", "1T", "149", "76",
	"CHILE", "5G", "20M", "HT", "1T", "149", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "149", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "149", "76",
	"CN", "5G", "20M", "HT", "1T", "149", "-128",
	"FCC", "5G", "20M", "HT", "1T", "153", "76",
	"ETSI", "5G", "20M", "HT", "1T", "153", "-128",
	"MKK", "5G", "20M", "HT", "1T", "153", "127",
	"IC", "5G", "20M", "HT", "1T", "153", "76",
	"KCC", "5G", "20M", "HT", "1T", "153", "74",
	"ACMA", "5G", "20M", "HT", "1T", "153", "76",
	"CHILE", "5G", "20M", "HT", "1T", "153", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "153", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "153", "76",
	"CN", "5G", "20M", "HT", "1T", "153", "-128",
	"FCC", "5G", "20M", "HT", "1T", "157", "76",
	"ETSI", "5G", "20M", "HT", "1T", "157", "-128",
	"MKK", "5G", "20M", "HT", "1T", "157", "127",
	"IC", "5G", "20M", "HT", "1T", "157", "76",
	"KCC", "5G", "20M", "HT", "1T", "157", "74",
	"ACMA", "5G", "20M", "HT", "1T", "157", "76",
	"CHILE", "5G", "20M", "HT", "1T", "157", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "157", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "157", "76",
	"CN", "5G", "20M", "HT", "1T", "157", "-128",
	"FCC", "5G", "20M", "HT", "1T", "161", "76",
	"ETSI", "5G", "20M", "HT", "1T", "161", "-128",
	"MKK", "5G", "20M", "HT", "1T", "161", "127",
	"IC", "5G", "20M", "HT", "1T", "161", "76",
	"KCC", "5G", "20M", "HT", "1T", "161", "74",
	"ACMA", "5G", "20M", "HT", "1T", "161", "76",
	"CHILE", "5G", "20M", "HT", "1T", "161", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "161", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "161", "76",
	"CN", "5G", "20M", "HT", "1T", "161", "-128",
	"FCC", "5G", "20M", "HT", "1T", "165", "76",
	"ETSI", "5G", "20M", "HT", "1T", "165", "-128",
	"MKK", "5G", "20M", "HT", "1T", "165", "127",
	"IC", "5G", "20M", "HT", "1T", "165", "76",
	"KCC", "5G", "20M", "HT", "1T", "165", "74",
	"ACMA", "5G", "20M", "HT", "1T", "165", "76",
	"CHILE", "5G", "20M", "HT", "1T", "165", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "165", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "165", "76",
	"CN", "5G", "20M", "HT", "1T", "165", "-128",
	"FCC", "5G", "20M", "HT", "2T", "36", "68",
	"ETSI", "5G", "20M", "HT", "2T", "36", "38",
	"MKK", "5G", "20M", "HT", "2T", "36", "50",
	"IC", "5G", "20M", "HT", "2T", "36", "38",
	"KCC", "5G", "20M", "HT", "2T", "36", "66",
	"ACMA", "5G", "20M", "HT", "2T", "36", "38",
	"CHILE", "5G", "20M", "HT", "2T", "36", "52",
	"UKRAINE", "5G", "20M", "HT", "2T", "36", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "36", "50",
	"CN", "5G", "20M", "HT", "2T", "36", "38",
	"FCC", "5G", "20M", "HT", "2T", "40", "68",
	"ETSI", "5G", "20M", "HT", "2T", "40", "38",
	"MKK", "5G", "20M", "HT", "2T", "40", "50",
	"IC", "5G", "20M", "HT", "2T", "40", "38",
	"KCC", "5G", "20M", "HT", "2T", "40", "66",
	"ACMA", "5G", "20M", "HT", "2T", "40", "38",
	"CHILE", "5G", "20M", "HT", "2T", "40", "52",
	"UKRAINE", "5G", "20M", "HT", "2T", "40", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "40", "50",
	"CN", "5G", "20M", "HT", "2T", "40", "38",
	"FCC", "5G", "20M", "HT", "2T", "44", "68",
	"ETSI", "5G", "20M", "HT", "2T", "44", "38",
	"MKK", "5G", "20M", "HT", "2T", "44", "50",
	"IC", "5G", "20M", "HT", "2T", "44", "38",
	"KCC", "5G", "20M", "HT", "2T", "44", "66",
	"ACMA", "5G", "20M", "HT", "2T", "44", "38",
	"CHILE", "5G", "20M", "HT", "2T", "44", "52",
	"UKRAINE", "5G", "20M", "HT", "2T", "44", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "44", "50",
	"CN", "5G", "20M", "HT", "2T", "44", "38",
	"FCC", "5G", "20M", "HT", "2T", "48", "68",
	"ETSI", "5G", "20M", "HT", "2T", "48", "38",
	"MKK", "5G", "20M", "HT", "2T", "48", "50",
	"IC", "5G", "20M", "HT", "2T", "48", "38",
	"KCC", "5G", "20M", "HT", "2T", "48", "36",
	"ACMA", "5G", "20M", "HT", "2T", "48", "38",
	"CHILE", "5G", "20M", "HT", "2T", "48", "52",
	"UKRAINE", "5G", "20M", "HT", "2T", "48", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "48", "50",
	"CN", "5G", "20M", "HT", "2T", "48", "38",
	"FCC", "5G", "20M", "HT", "2T", "52", "68",
	"ETSI", "5G", "20M", "HT", "2T", "52", "38",
	"MKK", "5G", "20M", "HT", "2T", "52", "50",
	"IC", "5G", "20M", "HT", "2T", "52", "40",
	"KCC", "5G", "20M", "HT", "2T", "52", "66",
	"ACMA", "5G", "20M", "HT", "2T", "52", "38",
	"CHILE", "5G", "20M", "HT", "2T", "52", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "52", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "52", "68",
	"CN", "5G", "20M", "HT", "2T", "52", "38",
	"FCC", "5G", "20M", "HT", "2T", "56", "68",
	"ETSI", "5G", "20M", "HT", "2T", "56", "38",
	"MKK", "5G", "20M", "HT", "2T", "56", "50",
	"IC", "5G", "20M", "HT", "2T", "56", "40",
	"KCC", "5G", "20M", "HT", "2T", "56", "66",
	"ACMA", "5G", "20M", "HT", "2T", "56", "38",
	"CHILE", "5G", "20M", "HT", "2T", "56", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "56", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "56", "68",
	"CN", "5G", "20M", "HT", "2T", "56", "38",
	"FCC", "5G", "20M", "HT", "2T", "60", "66",
	"ETSI", "5G", "20M", "HT", "2T", "60", "38",
	"MKK", "5G", "20M", "HT", "2T", "60", "50",
	"IC", "5G", "20M", "HT", "2T", "60", "40",
	"KCC", "5G", "20M", "HT", "2T", "60", "66",
	"ACMA", "5G", "20M", "HT", "2T", "60", "38",
	"CHILE", "5G", "20M", "HT", "2T", "60", "66",
	"UKRAINE", "5G", "20M", "HT", "2T", "60", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "60", "66",
	"CN", "5G", "20M", "HT", "2T", "60", "38",
	"FCC", "5G", "20M", "HT", "2T", "64", "68",
	"ETSI", "5G", "20M", "HT", "2T", "64", "38",
	"MKK", "5G", "20M", "HT", "2T", "64", "50",
	"IC", "5G", "20M", "HT", "2T", "64", "40",
	"KCC", "5G", "20M", "HT", "2T", "64", "66",
	"ACMA", "5G", "20M", "HT", "2T", "64", "38",
	"CHILE", "5G", "20M", "HT", "2T", "64", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "64", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "64", "68",
	"CN", "5G", "20M", "HT", "2T", "64", "38",
	"FCC", "5G", "20M", "HT", "2T", "100", "60",
	"ETSI", "5G", "20M", "HT", "2T", "100", "38",
	"MKK", "5G", "20M", "HT", "2T", "100", "70",
	"IC", "5G", "20M", "HT", "2T", "100", "60",
	"KCC", "5G", "20M", "HT", "2T", "100", "64",
	"ACMA", "5G", "20M", "HT", "2T", "100", "38",
	"CHILE", "5G", "20M", "HT", "2T", "100", "60",
	"UKRAINE", "5G", "20M", "HT", "2T", "100", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "100", "60",
	"CN", "5G", "20M", "HT", "2T", "100", "127",
	"FCC", "5G", "20M", "HT", "2T", "104", "68",
	"ETSI", "5G", "20M", "HT", "2T", "104", "38",
	"MKK", "5G", "20M", "HT", "2T", "104", "70",
	"IC", "5G", "20M", "HT", "2T", "104", "68",
	"KCC", "5G", "20M", "HT", "2T", "104", "64",
	"ACMA", "5G", "20M", "HT", "2T", "104", "38",
	"CHILE", "5G", "20M", "HT", "2T", "104", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "104", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "104", "68",
	"CN", "5G", "20M", "HT", "2T", "104", "127",
	"FCC", "5G", "20M", "HT", "2T", "108", "68",
	"ETSI", "5G", "20M", "HT", "2T", "108", "38",
	"MKK", "5G", "20M", "HT", "2T", "108", "70",
	"IC", "5G", "20M", "HT", "2T", "108", "68",
	"KCC", "5G", "20M", "HT", "2T", "108", "64",
	"ACMA", "5G", "20M", "HT", "2T", "108", "38",
	"CHILE", "5G", "20M", "HT", "2T", "108", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "108", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "108", "68",
	"CN", "5G", "20M", "HT", "2T", "108", "127",
	"FCC", "5G", "20M", "HT", "2T", "112", "68",
	"ETSI", "5G", "20M", "HT", "2T", "112", "38",
	"MKK", "5G", "20M", "HT", "2T", "112", "70",
	"IC", "5G", "20M", "HT", "2T", "112", "68",
	"KCC", "5G", "20M", "HT", "2T", "112", "64",
	"ACMA", "5G", "20M", "HT", "2T", "112", "38",
	"CHILE", "5G", "20M", "HT", "2T", "112", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "112", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "112", "68",
	"CN", "5G", "20M", "HT", "2T", "112", "127",
	"FCC", "5G", "20M", "HT", "2T", "116", "68",
	"ETSI", "5G", "20M", "HT", "2T", "116", "38",
	"MKK", "5G", "20M", "HT", "2T", "116", "70",
	"IC", "5G", "20M", "HT", "2T", "116", "68",
	"KCC", "5G", "20M", "HT", "2T", "116", "64",
	"ACMA", "5G", "20M", "HT", "2T", "116", "38",
	"CHILE", "5G", "20M", "HT", "2T", "116", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "116", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "116", "68",
	"CN", "5G", "20M", "HT", "2T", "116", "127",
	"FCC", "5G", "20M", "HT", "2T", "120", "68",
	"ETSI", "5G", "20M", "HT", "2T", "120", "38",
	"MKK", "5G", "20M", "HT", "2T", "120", "70",
	"IC", "5G", "20M", "HT", "2T", "120", "127",
	"KCC", "5G", "20M", "HT", "2T", "120", "64",
	"ACMA", "5G", "20M", "HT", "2T", "120", "127",
	"CHILE", "5G", "20M", "HT", "2T", "120", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "120", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "120", "68",
	"CN", "5G", "20M", "HT", "2T", "120", "127",
	"FCC", "5G", "20M", "HT", "2T", "124", "68",
	"ETSI", "5G", "20M", "HT", "2T", "124", "38",
	"MKK", "5G", "20M", "HT", "2T", "124", "70",
	"IC", "5G", "20M", "HT", "2T", "124", "127",
	"KCC", "5G", "20M", "HT", "2T", "124", "64",
	"ACMA", "5G", "20M", "HT", "2T", "124", "127",
	"CHILE", "5G", "20M", "HT", "2T", "124", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "124", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "124", "68",
	"CN", "5G", "20M", "HT", "2T", "124", "127",
	"FCC", "5G", "20M", "HT", "2T", "128", "68",
	"ETSI", "5G", "20M", "HT", "2T", "128", "38",
	"MKK", "5G", "20M", "HT", "2T", "128", "70",
	"IC", "5G", "20M", "HT", "2T", "128", "127",
	"KCC", "5G", "20M", "HT", "2T", "128", "64",
	"ACMA", "5G", "20M", "HT", "2T", "128", "127",
	"CHILE", "5G", "20M", "HT", "2T", "128", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "128", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "128", "68",
	"CN", "5G", "20M", "HT", "2T", "128", "127",
	"FCC", "5G", "20M", "HT", "2T", "132", "68",
	"ETSI", "5G", "20M", "HT", "2T", "132", "38",
	"MKK", "5G", "20M", "HT", "2T", "132", "70",
	"IC", "5G", "20M", "HT", "2T", "132", "68",
	"KCC", "5G", "20M", "HT", "2T", "132", "64",
	"ACMA", "5G", "20M", "HT", "2T", "132", "38",
	"CHILE", "5G", "20M", "HT", "2T", "132", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "132", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "132", "68",
	"CN", "5G", "20M", "HT", "2T", "132", "127",
	"FCC", "5G", "20M", "HT", "2T", "136", "68",
	"ETSI", "5G", "20M", "HT", "2T", "136", "38",
	"MKK", "5G", "20M", "HT", "2T", "136", "70",
	"IC", "5G", "20M", "HT", "2T", "136", "68",
	"KCC", "5G", "20M", "HT", "2T", "136", "64",
	"ACMA", "5G", "20M", "HT", "2T", "136", "38",
	"CHILE", "5G", "20M", "HT", "2T", "136", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "136", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "136", "68",
	"CN", "5G", "20M", "HT", "2T", "136", "127",
	"FCC", "5G", "20M", "HT", "2T", "140", "60",
	"ETSI", "5G", "20M", "HT", "2T", "140", "38",
	"MKK", "5G", "20M", "HT", "2T", "140", "70",
	"IC", "5G", "20M", "HT", "2T", "140", "60",
	"KCC", "5G", "20M", "HT", "2T", "140", "64",
	"ACMA", "5G", "20M", "HT", "2T", "140", "38",
	"CHILE", "5G", "20M", "HT", "2T", "140", "60",
	"UKRAINE", "5G", "20M", "HT", "2T", "140", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "140", "60",
	"CN", "5G", "20M", "HT", "2T", "140", "127",
	"FCC", "5G", "20M", "HT", "2T", "144", "68",
	"ETSI", "5G", "20M", "HT", "2T", "144", "127",
	"MKK", "5G", "20M", "HT", "2T", "144", "127",
	"IC", "5G", "20M", "HT", "2T", "144", "68",
	"KCC", "5G", "20M", "HT", "2T", "144", "64",
	"ACMA", "5G", "20M", "HT", "2T", "144", "127",
	"CHILE", "5G", "20M", "HT", "2T", "144", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "144", "127",
	"MEXICO", "5G", "20M", "HT", "2T", "144", "68",
	"CN", "5G", "20M", "HT", "2T", "144", "127",
	"FCC", "5G", "20M", "HT", "2T", "149", "76",
	"ETSI", "5G", "20M", "HT", "2T", "149", "-128",
	"MKK", "5G", "20M", "HT", "2T", "149", "127",
	"IC", "5G", "20M", "HT", "2T", "149", "76",
	"KCC", "5G", "20M", "HT", "2T", "149", "60",
	"ACMA", "5G", "20M", "HT", "2T", "149", "76",
	"CHILE", "5G", "20M", "HT", "2T", "149", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "149", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "149", "72",
	"CN", "5G", "20M", "HT", "2T", "149", "-128",
	"FCC", "5G", "20M", "HT", "2T", "153", "76",
	"ETSI", "5G", "20M", "HT", "2T", "153", "-128",
	"MKK", "5G", "20M", "HT", "2T", "153", "127",
	"IC", "5G", "20M", "HT", "2T", "153", "76",
	"KCC", "5G", "20M", "HT", "2T", "153", "60",
	"ACMA", "5G", "20M", "HT", "2T", "153", "76",
	"CHILE", "5G", "20M", "HT", "2T", "153", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "153", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "153", "76",
	"CN", "5G", "20M", "HT", "2T", "153", "-128",
	"FCC", "5G", "20M", "HT", "2T", "157", "76",
	"ETSI", "5G", "20M", "HT", "2T", "157", "-128",
	"MKK", "5G", "20M", "HT", "2T", "157", "127",
	"IC", "5G", "20M", "HT", "2T", "157", "76",
	"KCC", "5G", "20M", "HT", "2T", "157", "60",
	"ACMA", "5G", "20M", "HT", "2T", "157", "76",
	"CHILE", "5G", "20M", "HT", "2T", "157", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "157", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "157", "76",
	"CN", "5G", "20M", "HT", "2T", "157", "-128",
	"FCC", "5G", "20M", "HT", "2T", "161", "76",
	"ETSI", "5G", "20M", "HT", "2T", "161", "-128",
	"MKK", "5G", "20M", "HT", "2T", "161", "127",
	"IC", "5G", "20M", "HT", "2T", "161", "76",
	"KCC", "5G", "20M", "HT", "2T", "161", "60",
	"ACMA", "5G", "20M", "HT", "2T", "161", "76",
	"CHILE", "5G", "20M", "HT", "2T", "161", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "161", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "161", "76",
	"CN", "5G", "20M", "HT", "2T", "161", "-128",
	"FCC", "5G", "20M", "HT", "2T", "165", "76",
	"ETSI", "5G", "20M", "HT", "2T", "165", "-128",
	"MKK", "5G", "20M", "HT", "2T", "165", "127",
	"IC", "5G", "20M", "HT", "2T", "165", "76",
	"KCC", "5G", "20M", "HT", "2T", "165", "60",
	"ACMA", "5G", "20M", "HT", "2T", "165", "76",
	"CHILE", "5G", "20M", "HT", "2T", "165", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "165", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "165", "76",
	"CN", "5G", "20M", "HT", "2T", "165", "-128",
	"FCC", "5G", "40M", "HT", "1T", "38", "66",
	"ETSI", "5G", "40M", "HT", "1T", "38", "64",
	"MKK", "5G", "40M", "HT", "1T", "38", "62",
	"IC", "5G", "40M", "HT", "1T", "38", "64",
	"KCC", "5G", "40M", "HT", "1T", "38", "72",
	"ACMA", "5G", "40M", "HT", "1T", "38", "64",
	"CHILE", "5G", "40M", "HT", "1T", "38", "64",
	"UKRAINE", "5G", "40M", "HT", "1T", "38", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "38", "62",
	"CN", "5G", "40M", "HT", "1T", "38", "64",
	"FCC", "5G", "40M", "HT", "1T", "46", "72",
	"ETSI", "5G", "40M", "HT", "1T", "46", "64",
	"MKK", "5G", "40M", "HT", "1T", "46", "62",
	"IC", "5G", "40M", "HT", "1T", "46", "64",
	"KCC", "5G", "40M", "HT", "1T", "46", "60",
	"ACMA", "5G", "40M", "HT", "1T", "46", "64",
	"CHILE", "5G", "40M", "HT", "1T", "46", "64",
	"UKRAINE", "5G", "40M", "HT", "1T", "46", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "46", "62",
	"CN", "5G", "40M", "HT", "1T", "46", "64",
	"FCC", "5G", "40M", "HT", "1T", "54", "72",
	"ETSI", "5G", "40M", "HT", "1T", "54", "64",
	"MKK", "5G", "40M", "HT", "1T", "54", "62",
	"IC", "5G", "40M", "HT", "1T", "54", "64",
	"KCC", "5G", "40M", "HT", "1T", "54", "72",
	"ACMA", "5G", "40M", "HT", "1T", "54", "64",
	"CHILE", "5G", "40M", "HT", "1T", "54", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "54", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "54", "72",
	"CN", "5G", "40M", "HT", "1T", "54", "64",
	"FCC", "5G", "40M", "HT", "1T", "62", "64",
	"ETSI", "5G", "40M", "HT", "1T", "62", "64",
	"MKK", "5G", "40M", "HT", "1T", "62", "62",
	"IC", "5G", "40M", "HT", "1T", "62", "64",
	"KCC", "5G", "40M", "HT", "1T", "62", "70",
	"ACMA", "5G", "40M", "HT", "1T", "62", "64",
	"CHILE", "5G", "40M", "HT", "1T", "62", "64",
	"UKRAINE", "5G", "40M", "HT", "1T", "62", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "62", "64",
	"CN", "5G", "40M", "HT", "1T", "62", "64",
	"FCC", "5G", "40M", "HT", "1T", "102", "58",
	"ETSI", "5G", "40M", "HT", "1T", "102", "64",
	"MKK", "5G", "40M", "HT", "1T", "102", "72",
	"IC", "5G", "40M", "HT", "1T", "102", "58",
	"KCC", "5G", "40M", "HT", "1T", "102", "72",
	"ACMA", "5G", "40M", "HT", "1T", "102", "64",
	"CHILE", "5G", "40M", "HT", "1T", "102", "58",
	"UKRAINE", "5G", "40M", "HT", "1T", "102", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "102", "58",
	"CN", "5G", "40M", "HT", "1T", "102", "127",
	"FCC", "5G", "40M", "HT", "1T", "110", "72",
	"ETSI", "5G", "40M", "HT", "1T", "110", "64",
	"MKK", "5G", "40M", "HT", "1T", "110", "72",
	"IC", "5G", "40M", "HT", "1T", "110", "72",
	"KCC", "5G", "40M", "HT", "1T", "110", "72",
	"ACMA", "5G", "40M", "HT", "1T", "110", "64",
	"CHILE", "5G", "40M", "HT", "1T", "110", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "110", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "110", "72",
	"CN", "5G", "40M", "HT", "1T", "110", "127",
	"FCC", "5G", "40M", "HT", "1T", "118", "72",
	"ETSI", "5G", "40M", "HT", "1T", "118", "64",
	"MKK", "5G", "40M", "HT", "1T", "118", "72",
	"IC", "5G", "40M", "HT", "1T", "118", "127",
	"KCC", "5G", "40M", "HT", "1T", "118", "72",
	"ACMA", "5G", "40M", "HT", "1T", "118", "127",
	"CHILE", "5G", "40M", "HT", "1T", "118", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "118", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "118", "72",
	"CN", "5G", "40M", "HT", "1T", "118", "127",
	"FCC", "5G", "40M", "HT", "1T", "126", "72",
	"ETSI", "5G", "40M", "HT", "1T", "126", "64",
	"MKK", "5G", "40M", "HT", "1T", "126", "72",
	"IC", "5G", "40M", "HT", "1T", "126", "127",
	"KCC", "5G", "40M", "HT", "1T", "126", "72",
	"ACMA", "5G", "40M", "HT", "1T", "126", "127",
	"CHILE", "5G", "40M", "HT", "1T", "126", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "126", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "126", "72",
	"CN", "5G", "40M", "HT", "1T", "126", "127",
	"FCC", "5G", "40M", "HT", "1T", "134", "72",
	"ETSI", "5G", "40M", "HT", "1T", "134", "64",
	"MKK", "5G", "40M", "HT", "1T", "134", "72",
	"IC", "5G", "40M", "HT", "1T", "134", "72",
	"KCC", "5G", "40M", "HT", "1T", "134", "72",
	"ACMA", "5G", "40M", "HT", "1T", "134", "64",
	"CHILE", "5G", "40M", "HT", "1T", "134", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "134", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "134", "72",
	"CN", "5G", "40M", "HT", "1T", "134", "127",
	"FCC", "5G", "40M", "HT", "1T", "142", "72",
	"ETSI", "5G", "40M", "HT", "1T", "142", "127",
	"MKK", "5G", "40M", "HT", "1T", "142", "127",
	"IC", "5G", "40M", "HT", "1T", "142", "72",
	"KCC", "5G", "40M", "HT", "1T", "142", "72",
	"ACMA", "5G", "40M", "HT", "1T", "142", "127",
	"CHILE", "5G", "40M", "HT", "1T", "142", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "142", "127",
	"MEXICO", "5G", "40M", "HT", "1T", "142", "72",
	"CN", "5G", "40M", "HT", "1T", "142", "127",
	"FCC", "5G", "40M", "HT", "1T", "151", "72",
	"ETSI", "5G", "40M", "HT", "1T", "151", "-128",
	"MKK", "5G", "40M", "HT", "1T", "151", "127",
	"IC", "5G", "40M", "HT", "1T", "151", "72",
	"KCC", "5G", "40M", "HT", "1T", "151", "72",
	"ACMA", "5G", "40M", "HT", "1T", "151", "72",
	"CHILE", "5G", "40M", "HT", "1T", "151", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "151", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "151", "72",
	"CN", "5G", "40M", "HT", "1T", "151", "-128",
	"FCC", "5G", "40M", "HT", "1T", "159", "72",
	"ETSI", "5G", "40M", "HT", "1T", "159", "-128",
	"MKK", "5G", "40M", "HT", "1T", "159", "127",
	"IC", "5G", "40M", "HT", "1T", "159", "72",
	"KCC", "5G", "40M", "HT", "1T", "159", "72",
	"ACMA", "5G", "40M", "HT", "1T", "159", "72",
	"CHILE", "5G", "40M", "HT", "1T", "159", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "159", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "159", "72",
	"CN", "5G", "40M", "HT", "1T", "159", "-128",
	"FCC", "5G", "40M", "HT", "2T", "38", "60",
	"ETSI", "5G", "40M", "HT", "2T", "38", "40",
	"MKK", "5G", "40M", "HT", "2T", "38", "50",
	"IC", "5G", "40M", "HT", "2T", "38", "40",
	"KCC", "5G", "40M", "HT", "2T", "38", "62",
	"ACMA", "5G", "40M", "HT", "2T", "38", "40",
	"CHILE", "5G", "40M", "HT", "2T", "38", "52",
	"UKRAINE", "5G", "40M", "HT", "2T", "38", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "38", "50",
	"CN", "5G", "40M", "HT", "2T", "38", "40",
	"FCC", "5G", "40M", "HT", "2T", "46", "68",
	"ETSI", "5G", "40M", "HT", "2T", "46", "40",
	"MKK", "5G", "40M", "HT", "2T", "46", "50",
	"IC", "5G", "40M", "HT", "2T", "46", "40",
	"KCC", "5G", "40M", "HT", "2T", "46", "46",
	"ACMA", "5G", "40M", "HT", "2T", "46", "40",
	"CHILE", "5G", "40M", "HT", "2T", "46", "52",
	"UKRAINE", "5G", "40M", "HT", "2T", "46", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "46", "50",
	"CN", "5G", "40M", "HT", "2T", "46", "40",
	"FCC", "5G", "40M", "HT", "2T", "54", "68",
	"ETSI", "5G", "40M", "HT", "2T", "54", "40",
	"MKK", "5G", "40M", "HT", "2T", "54", "50",
	"IC", "5G", "40M", "HT", "2T", "54", "40",
	"KCC", "5G", "40M", "HT", "2T", "54", "62",
	"ACMA", "5G", "40M", "HT", "2T", "54", "40",
	"CHILE", "5G", "40M", "HT", "2T", "54", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "54", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "54", "68",
	"CN", "5G", "40M", "HT", "2T", "54", "40",
	"FCC", "5G", "40M", "HT", "2T", "62", "58",
	"ETSI", "5G", "40M", "HT", "2T", "62", "40",
	"MKK", "5G", "40M", "HT", "2T", "62", "48",
	"IC", "5G", "40M", "HT", "2T", "62", "40",
	"KCC", "5G", "40M", "HT", "2T", "62", "58",
	"ACMA", "5G", "40M", "HT", "2T", "62", "40",
	"CHILE", "5G", "40M", "HT", "2T", "62", "58",
	"UKRAINE", "5G", "40M", "HT", "2T", "62", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "62", "58",
	"CN", "5G", "40M", "HT", "2T", "62", "40",
	"FCC", "5G", "40M", "HT", "2T", "102", "54",
	"ETSI", "5G", "40M", "HT", "2T", "102", "40",
	"MKK", "5G", "40M", "HT", "2T", "102", "70",
	"IC", "5G", "40M", "HT", "2T", "102", "54",
	"KCC", "5G", "40M", "HT", "2T", "102", "64",
	"ACMA", "5G", "40M", "HT", "2T", "102", "40",
	"CHILE", "5G", "40M", "HT", "2T", "102", "54",
	"UKRAINE", "5G", "40M", "HT", "2T", "102", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "102", "54",
	"CN", "5G", "40M", "HT", "2T", "102", "127",
	"FCC", "5G", "40M", "HT", "2T", "110", "68",
	"ETSI", "5G", "40M", "HT", "2T", "110", "40",
	"MKK", "5G", "40M", "HT", "2T", "110", "70",
	"IC", "5G", "40M", "HT", "2T", "110", "68",
	"KCC", "5G", "40M", "HT", "2T", "110", "64",
	"ACMA", "5G", "40M", "HT", "2T", "110", "40",
	"CHILE", "5G", "40M", "HT", "2T", "110", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "110", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "110", "68",
	"CN", "5G", "40M", "HT", "2T", "110", "127",
	"FCC", "5G", "40M", "HT", "2T", "118", "68",
	"ETSI", "5G", "40M", "HT", "2T", "118", "40",
	"MKK", "5G", "40M", "HT", "2T", "118", "70",
	"IC", "5G", "40M", "HT", "2T", "118", "127",
	"KCC", "5G", "40M", "HT", "2T", "118", "64",
	"ACMA", "5G", "40M", "HT", "2T", "118", "127",
	"CHILE", "5G", "40M", "HT", "2T", "118", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "118", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "118", "68",
	"CN", "5G", "40M", "HT", "2T", "118", "127",
	"FCC", "5G", "40M", "HT", "2T", "126", "68",
	"ETSI", "5G", "40M", "HT", "2T", "126", "40",
	"MKK", "5G", "40M", "HT", "2T", "126", "70",
	"IC", "5G", "40M", "HT", "2T", "126", "127",
	"KCC", "5G", "40M", "HT", "2T", "126", "64",
	"ACMA", "5G", "40M", "HT", "2T", "126", "127",
	"CHILE", "5G", "40M", "HT", "2T", "126", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "126", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "126", "68",
	"CN", "5G", "40M", "HT", "2T", "126", "127",
	"FCC", "5G", "40M", "HT", "2T", "134", "68",
	"ETSI", "5G", "40M", "HT", "2T", "134", "40",
	"MKK", "5G", "40M", "HT", "2T", "134", "70",
	"IC", "5G", "40M", "HT", "2T", "134", "68",
	"KCC", "5G", "40M", "HT", "2T", "134", "64",
	"ACMA", "5G", "40M", "HT", "2T", "134", "40",
	"CHILE", "5G", "40M", "HT", "2T", "134", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "134", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "134", "68",
	"CN", "5G", "40M", "HT", "2T", "134", "127",
	"FCC", "5G", "40M", "HT", "2T", "142", "68",
	"ETSI", "5G", "40M", "HT", "2T", "142", "127",
	"MKK", "5G", "40M", "HT", "2T", "142", "127",
	"IC", "5G", "40M", "HT", "2T", "142", "68",
	"KCC", "5G", "40M", "HT", "2T", "142", "64",
	"ACMA", "5G", "40M", "HT", "2T", "142", "127",
	"CHILE", "5G", "40M", "HT", "2T", "142", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "142", "127",
	"MEXICO", "5G", "40M", "HT", "2T", "142", "68",
	"CN", "5G", "40M", "HT", "2T", "142", "127",
	"FCC", "5G", "40M", "HT", "2T", "151", "72",
	"ETSI", "5G", "40M", "HT", "2T", "151", "-128",
	"MKK", "5G", "40M", "HT", "2T", "151", "127",
	"IC", "5G", "40M", "HT", "2T", "151", "72",
	"KCC", "5G", "40M", "HT", "2T", "151", "66",
	"ACMA", "5G", "40M", "HT", "2T", "151", "72",
	"CHILE", "5G", "40M", "HT", "2T", "151", "72",
	"UKRAINE", "5G", "40M", "HT", "2T", "151", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "151", "68",
	"CN", "5G", "40M", "HT", "2T", "151", "-128",
	"FCC", "5G", "40M", "HT", "2T", "159", "72",
	"ETSI", "5G", "40M", "HT", "2T", "159", "-128",
	"MKK", "5G", "40M", "HT", "2T", "159", "127",
	"IC", "5G", "40M", "HT", "2T", "159", "72",
	"KCC", "5G", "40M", "HT", "2T", "159", "66",
	"ACMA", "5G", "40M", "HT", "2T", "159", "72",
	"CHILE", "5G", "40M", "HT", "2T", "159", "72",
	"UKRAINE", "5G", "40M", "HT", "2T", "159", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "159", "72",
	"CN", "5G", "40M", "HT", "2T", "159", "-128",
	"FCC", "5G", "80M", "VHT", "1T", "42", "64",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "64",
	"MKK", "5G", "80M", "VHT", "1T", "42", "64",
	"IC", "5G", "80M", "VHT", "1T", "42", "64",
	"KCC", "5G", "80M", "VHT", "1T", "42", "68",
	"ACMA", "5G", "80M", "VHT", "1T", "42", "64",
	"CHILE", "5G", "80M", "VHT", "1T", "42", "64",
	"UKRAINE", "5G", "80M", "VHT", "1T", "42", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "42", "62",
	"CN", "5G", "80M", "VHT", "1T", "42", "64",
	"FCC", "5G", "80M", "VHT", "1T", "58", "62",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "64",
	"MKK", "5G", "80M", "VHT", "1T", "58", "64",
	"IC", "5G", "80M", "VHT", "1T", "58", "62",
	"KCC", "5G", "80M", "VHT", "1T", "58", "64",
	"ACMA", "5G", "80M", "VHT", "1T", "58", "64",
	"CHILE", "5G", "80M", "VHT", "1T", "58", "62",
	"UKRAINE", "5G", "80M", "VHT", "1T", "58", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "58", "62",
	"CN", "5G", "80M", "VHT", "1T", "58", "64",
	"FCC", "5G", "80M", "VHT", "1T", "106", "58",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "64",
	"MKK", "5G", "80M", "VHT", "1T", "106", "72",
	"IC", "5G", "80M", "VHT", "1T", "106", "58",
	"KCC", "5G", "80M", "VHT", "1T", "106", "66",
	"ACMA", "5G", "80M", "VHT", "1T", "106", "64",
	"CHILE", "5G", "80M", "VHT", "1T", "106", "58",
	"UKRAINE", "5G", "80M", "VHT", "1T", "106", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "106", "58",
	"CN", "5G", "80M", "VHT", "1T", "106", "127",
	"FCC", "5G", "80M", "VHT", "1T", "122", "72",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "64",
	"MKK", "5G", "80M", "VHT", "1T", "122", "72",
	"IC", "5G", "80M", "VHT", "1T", "122", "127",
	"KCC", "5G", "80M", "VHT", "1T", "122", "68",
	"ACMA", "5G", "80M", "VHT", "1T", "122", "127",
	"CHILE", "5G", "80M", "VHT", "1T", "122", "72",
	"UKRAINE", "5G", "80M", "VHT", "1T", "122", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "122", "72",
	"CN", "5G", "80M", "VHT", "1T", "122", "127",
	"FCC", "5G", "80M", "VHT", "1T", "138", "72",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "127",
	"MKK", "5G", "80M", "VHT", "1T", "138", "127",
	"IC", "5G", "80M", "VHT", "1T", "138", "72",
	"KCC", "5G", "80M", "VHT", "1T", "138", "68",
	"ACMA", "5G", "80M", "VHT", "1T", "138", "127",
	"CHILE", "5G", "80M", "VHT", "1T", "138", "72",
	"UKRAINE", "5G", "80M", "VHT", "1T", "138", "127",
	"MEXICO", "5G", "80M", "VHT", "1T", "138", "72",
	"CN", "5G", "80M", "VHT", "1T", "138", "127",
	"FCC", "5G", "80M", "VHT", "1T", "155", "72",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "-128",
	"MKK", "5G", "80M", "VHT", "1T", "155", "127",
	"IC", "5G", "80M", "VHT", "1T", "155", "72",
	"KCC", "5G", "80M", "VHT", "1T", "155", "68",
	"ACMA", "5G", "80M", "VHT", "1T", "155", "72",
	"CHILE", "5G", "80M", "VHT", "1T", "155", "72",
	"UKRAINE", "5G", "80M", "VHT", "1T", "155", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "155", "68",
	"CN", "5G", "80M", "VHT", "1T", "155", "-128",
	"FCC", "5G", "80M", "VHT", "2T", "42", "54",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "40",
	"MKK", "5G", "80M", "VHT", "2T", "42", "50",
	"IC", "5G", "80M", "VHT", "2T", "42", "40",
	"KCC", "5G", "80M", "VHT", "2T", "42", "58",
	"ACMA", "5G", "80M", "VHT", "2T", "42", "40",
	"CHILE", "5G", "80M", "VHT", "2T", "42", "52",
	"UKRAINE", "5G", "80M", "VHT", "2T", "42", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "42", "50",
	"CN", "5G", "80M", "VHT", "2T", "42", "40",
	"FCC", "5G", "80M", "VHT", "2T", "58", "52",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "40",
	"MKK", "5G", "80M", "VHT", "2T", "58", "50",
	"IC", "5G", "80M", "VHT", "2T", "58", "40",
	"KCC", "5G", "80M", "VHT", "2T", "58", "56",
	"ACMA", "5G", "80M", "VHT", "2T", "58", "40",
	"CHILE", "5G", "80M", "VHT", "2T", "58", "52",
	"UKRAINE", "5G", "80M", "VHT", "2T", "58", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "58", "52",
	"CN", "5G", "80M", "VHT", "2T", "58", "40",
	"FCC", "5G", "80M", "VHT", "2T", "106", "50",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "40",
	"MKK", "5G", "80M", "VHT", "2T", "106", "72",
	"IC", "5G", "80M", "VHT", "2T", "106", "50",
	"KCC", "5G", "80M", "VHT", "2T", "106", "56",
	"ACMA", "5G", "80M", "VHT", "2T", "106", "40",
	"CHILE", "5G", "80M", "VHT", "2T", "106", "50",
	"UKRAINE", "5G", "80M", "VHT", "2T", "106", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "106", "50",
	"CN", "5G", "80M", "VHT", "2T", "106", "127",
	"FCC", "5G", "80M", "VHT", "2T", "122", "66",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "40",
	"MKK", "5G", "80M", "VHT", "2T", "122", "72",
	"IC", "5G", "80M", "VHT", "2T", "122", "127",
	"KCC", "5G", "80M", "VHT", "2T", "122", "56",
	"ACMA", "5G", "80M", "VHT", "2T", "122", "127",
	"CHILE", "5G", "80M", "VHT", "2T", "122", "66",
	"UKRAINE", "5G", "80M", "VHT", "2T", "122", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "122", "66",
	"CN", "5G", "80M", "VHT", "2T", "122", "127",
	"FCC", "5G", "80M", "VHT", "2T", "138", "66",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "127",
	"MKK", "5G", "80M", "VHT", "2T", "138", "127",
	"IC", "5G", "80M", "VHT", "2T", "138", "66",
	"KCC", "5G", "80M", "VHT", "2T", "138", "58",
	"ACMA", "5G", "80M", "VHT", "2T", "138", "127",
	"CHILE", "5G", "80M", "VHT", "2T", "138", "66",
	"UKRAINE", "5G", "80M", "VHT", "2T", "138", "127",
	"MEXICO", "5G", "80M", "VHT", "2T", "138", "66",
	"CN", "5G", "80M", "VHT", "2T", "138", "127",
	"FCC", "5G", "80M", "VHT", "2T", "155", "62",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "-128",
	"MKK", "5G", "80M", "VHT", "2T", "155", "127",
	"IC", "5G", "80M", "VHT", "2T", "155", "62",
	"KCC", "5G", "80M", "VHT", "2T", "155", "58",
	"ACMA", "5G", "80M", "VHT", "2T", "155", "72",
	"CHILE", "5G", "80M", "VHT", "2T", "155", "62",
	"UKRAINE", "5G", "80M", "VHT", "2T", "155", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "155", "62",
	"CN", "5G", "80M", "VHT", "2T", "155", "-128"
};
#endif

void
odm_read_and_config_mp_8822c_txpwr_lmt(struct dm_struct *dm)
{
#ifdef CONFIG_8822C

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822c_txpwr_lmt) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822c_txpwr_lmt;
#else
	u32	array_len =
			sizeof(array_mp_8822c_txpwr_lmt) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822c_txpwr_lmt;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822c(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type5.TXT
 ******************************************************************************/

#ifdef CONFIG_8822C_TYPE5
const char *array_mp_8822c_txpwr_lmt_type5[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "72",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "01", "72",
	"KCC", "2.4G", "20M", "CCK", "1T", "01", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "01", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "01", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "01", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "01", "72",
	"CN", "2.4G", "20M", "CCK", "1T", "01", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "72",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "02", "72",
	"KCC", "2.4G", "20M", "CCK", "1T", "02", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "02", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "02", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "02", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "02", "72",
	"CN", "2.4G", "20M", "CCK", "1T", "02", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "03", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "03", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "03", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "03", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "03", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "03", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "03", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "04", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "04", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "04", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "04", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "04", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "04", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "04", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "05", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "05", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "05", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "05", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "05", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "05", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "05", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "06", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "06", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "06", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "06", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "06", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "06", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "06", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "07", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "07", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "07", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "07", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "07", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "07", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "07", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "08", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "08", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "08", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "08", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "08", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "08", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "08", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "76",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "09", "76",
	"KCC", "2.4G", "20M", "CCK", "1T", "09", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "09", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "09", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "09", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "09", "76",
	"CN", "2.4G", "20M", "CCK", "1T", "09", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "72",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "10", "72",
	"KCC", "2.4G", "20M", "CCK", "1T", "10", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "10", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "10", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "10", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "10", "72",
	"CN", "2.4G", "20M", "CCK", "1T", "10", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "72",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "11", "72",
	"KCC", "2.4G", "20M", "CCK", "1T", "11", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "11", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "11", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "11", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "11", "72",
	"CN", "2.4G", "20M", "CCK", "1T", "11", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "52",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "12", "52",
	"KCC", "2.4G", "20M", "CCK", "1T", "12", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "12", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "12", "52",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "12", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "12", "52",
	"CN", "2.4G", "20M", "CCK", "1T", "12", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "48",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "60",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "13", "48",
	"KCC", "2.4G", "20M", "CCK", "1T", "13", "76",
	"ACMA", "2.4G", "20M", "CCK", "1T", "13", "60",
	"CHILE", "2.4G", "20M", "CCK", "1T", "13", "48",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "13", "60",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "13", "48",
	"CN", "2.4G", "20M", "CCK", "1T", "13", "60",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "127",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "68",
	"IC", "2.4G", "20M", "CCK", "1T", "14", "127",
	"KCC", "2.4G", "20M", "CCK", "1T", "14", "127",
	"ACMA", "2.4G", "20M", "CCK", "1T", "14", "127",
	"CHILE", "2.4G", "20M", "CCK", "1T", "14", "127",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "14", "127",
	"MEXICO", "2.4G", "20M", "CCK", "1T", "14", "127",
	"CN", "2.4G", "20M", "CCK", "1T", "14", "127",
	"FCC", "2.4G", "20M", "CCK", "2T", "01", "72",
	"ETSI", "2.4G", "20M", "CCK", "2T", "01", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "01", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "01", "72",
	"KCC", "2.4G", "20M", "CCK", "2T", "01", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "01", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "01", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "01", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "01", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "01", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "02", "72",
	"ETSI", "2.4G", "20M", "CCK", "2T", "02", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "02", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "02", "72",
	"KCC", "2.4G", "20M", "CCK", "2T", "02", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "02", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "02", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "02", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "02", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "02", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "03", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "03", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "03", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "03", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "03", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "03", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "03", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "03", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "03", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "03", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "04", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "04", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "04", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "04", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "04", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "04", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "04", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "04", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "04", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "04", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "05", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "05", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "05", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "05", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "05", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "05", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "05", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "05", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "05", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "05", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "06", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "06", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "06", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "06", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "06", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "06", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "06", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "06", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "06", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "06", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "07", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "07", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "07", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "07", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "07", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "07", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "07", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "07", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "07", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "07", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "08", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "08", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "08", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "08", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "08", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "08", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "08", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "08", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "08", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "08", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "09", "76",
	"ETSI", "2.4G", "20M", "CCK", "2T", "09", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "09", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "09", "76",
	"KCC", "2.4G", "20M", "CCK", "2T", "09", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "09", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "09", "76",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "09", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "09", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "09", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "10", "72",
	"ETSI", "2.4G", "20M", "CCK", "2T", "10", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "10", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "10", "72",
	"KCC", "2.4G", "20M", "CCK", "2T", "10", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "10", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "10", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "10", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "10", "62",
	"CN", "2.4G", "20M", "CCK", "2T", "10", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "11", "72",
	"ETSI", "2.4G", "20M", "CCK", "2T", "11", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "11", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "11", "72",
	"KCC", "2.4G", "20M", "CCK", "2T", "11", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "11", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "11", "72",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "11", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "11", "60",
	"CN", "2.4G", "20M", "CCK", "2T", "11", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "12", "52",
	"ETSI", "2.4G", "20M", "CCK", "2T", "12", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "12", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "12", "52",
	"KCC", "2.4G", "20M", "CCK", "2T", "12", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "12", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "12", "52",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "12", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "12", "52",
	"CN", "2.4G", "20M", "CCK", "2T", "12", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "13", "36",
	"ETSI", "2.4G", "20M", "CCK", "2T", "13", "48",
	"MKK", "2.4G", "20M", "CCK", "2T", "13", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "13", "36",
	"KCC", "2.4G", "20M", "CCK", "2T", "13", "68",
	"ACMA", "2.4G", "20M", "CCK", "2T", "13", "48",
	"CHILE", "2.4G", "20M", "CCK", "2T", "13", "36",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "13", "48",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "13", "36",
	"CN", "2.4G", "20M", "CCK", "2T", "13", "48",
	"FCC", "2.4G", "20M", "CCK", "2T", "14", "127",
	"ETSI", "2.4G", "20M", "CCK", "2T", "14", "127",
	"MKK", "2.4G", "20M", "CCK", "2T", "14", "56",
	"IC", "2.4G", "20M", "CCK", "2T", "14", "127",
	"KCC", "2.4G", "20M", "CCK", "2T", "14", "127",
	"ACMA", "2.4G", "20M", "CCK", "2T", "14", "127",
	"CHILE", "2.4G", "20M", "CCK", "2T", "14", "127",
	"UKRAINE", "2.4G", "20M", "CCK", "2T", "14", "127",
	"MEXICO", "2.4G", "20M", "CCK", "2T", "14", "127",
	"CN", "2.4G", "20M", "CCK", "2T", "14", "127",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "52",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "01", "52",
	"KCC", "2.4G", "20M", "OFDM", "1T", "01", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "01", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "01", "52",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "01", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "01", "52",
	"CN", "2.4G", "20M", "OFDM", "1T", "01", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"KCC", "2.4G", "20M", "OFDM", "1T", "02", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"CN", "2.4G", "20M", "OFDM", "1T", "02", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"KCC", "2.4G", "20M", "OFDM", "1T", "03", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "03", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "03", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"CN", "2.4G", "20M", "OFDM", "1T", "03", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "68",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "04", "68",
	"KCC", "2.4G", "20M", "OFDM", "1T", "04", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "04", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "04", "68",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "04", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "04", "68",
	"CN", "2.4G", "20M", "OFDM", "1T", "04", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"KCC", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "05", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "05", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "05", "76",
	"CN", "2.4G", "20M", "OFDM", "1T", "05", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"KCC", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "06", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "06", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "06", "76",
	"CN", "2.4G", "20M", "OFDM", "1T", "06", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"KCC", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "07", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "07", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "07", "76",
	"CN", "2.4G", "20M", "OFDM", "1T", "07", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "68",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "08", "68",
	"KCC", "2.4G", "20M", "OFDM", "1T", "08", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "08", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "08", "68",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "08", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "08", "68",
	"CN", "2.4G", "20M", "OFDM", "1T", "08", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"KCC", "2.4G", "20M", "OFDM", "1T", "09", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "09", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "09", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"CN", "2.4G", "20M", "OFDM", "1T", "09", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"KCC", "2.4G", "20M", "OFDM", "1T", "10", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"CN", "2.4G", "20M", "OFDM", "1T", "10", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"KCC", "2.4G", "20M", "OFDM", "1T", "11", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "11", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "11", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"CN", "2.4G", "20M", "OFDM", "1T", "11", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"KCC", "2.4G", "20M", "OFDM", "1T", "12", "76",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "12", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "12", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"CN", "2.4G", "20M", "OFDM", "1T", "12", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "60",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "76",
	"IC", "2.4G", "20M", "OFDM", "1T", "13", "28",
	"KCC", "2.4G", "20M", "OFDM", "1T", "13", "70",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "13", "60",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "13", "28",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "13", "60",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "13", "28",
	"CN", "2.4G", "20M", "OFDM", "1T", "13", "60",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"IC", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"KCC", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"MEXICO", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"CN", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"FCC", "2.4G", "20M", "OFDM", "2T", "01", "52",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "01", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "01", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "01", "52",
	"KCC", "2.4G", "20M", "OFDM", "2T", "01", "68",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "01", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "01", "52",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "01", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "01", "52",
	"CN", "2.4G", "20M", "OFDM", "2T", "01", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "02", "60",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "02", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "02", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "02", "60",
	"KCC", "2.4G", "20M", "OFDM", "2T", "02", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "02", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "02", "60",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "02", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "02", "60",
	"CN", "2.4G", "20M", "OFDM", "2T", "02", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "03", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"KCC", "2.4G", "20M", "OFDM", "2T", "03", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "03", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "03", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "03", "64",
	"CN", "2.4G", "20M", "OFDM", "2T", "03", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "04", "68",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "04", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "04", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "04", "68",
	"KCC", "2.4G", "20M", "OFDM", "2T", "04", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "04", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "04", "68",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "04", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "04", "68",
	"CN", "2.4G", "20M", "OFDM", "2T", "04", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "05", "76",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "05", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "05", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "05", "76",
	"KCC", "2.4G", "20M", "OFDM", "2T", "05", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "05", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "05", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "05", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "05", "76",
	"CN", "2.4G", "20M", "OFDM", "2T", "05", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "06", "76",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "06", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "06", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "06", "76",
	"KCC", "2.4G", "20M", "OFDM", "2T", "06", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "06", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "06", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "06", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "06", "76",
	"CN", "2.4G", "20M", "OFDM", "2T", "06", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "07", "76",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "07", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "07", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "07", "76",
	"KCC", "2.4G", "20M", "OFDM", "2T", "07", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "07", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "07", "76",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "07", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "07", "76",
	"CN", "2.4G", "20M", "OFDM", "2T", "07", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "08", "68",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "08", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "08", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "08", "68",
	"KCC", "2.4G", "20M", "OFDM", "2T", "08", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "08", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "08", "68",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "08", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "08", "68",
	"CN", "2.4G", "20M", "OFDM", "2T", "08", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "09", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"KCC", "2.4G", "20M", "OFDM", "2T", "09", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "09", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "09", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "09", "64",
	"CN", "2.4G", "20M", "OFDM", "2T", "09", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "10", "60",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "10", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "10", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "10", "60",
	"KCC", "2.4G", "20M", "OFDM", "2T", "10", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "10", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "10", "60",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "10", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "10", "60",
	"CN", "2.4G", "20M", "OFDM", "2T", "10", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "11", "52",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "11", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "11", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "11", "52",
	"KCC", "2.4G", "20M", "OFDM", "2T", "11", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "11", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "11", "52",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "11", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "11", "52",
	"CN", "2.4G", "20M", "OFDM", "2T", "11", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "12", "40",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "12", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "12", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "12", "40",
	"KCC", "2.4G", "20M", "OFDM", "2T", "12", "70",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "12", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "12", "40",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "12", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "12", "40",
	"CN", "2.4G", "20M", "OFDM", "2T", "12", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "13", "28",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "13", "48",
	"MKK", "2.4G", "20M", "OFDM", "2T", "13", "64",
	"IC", "2.4G", "20M", "OFDM", "2T", "13", "28",
	"KCC", "2.4G", "20M", "OFDM", "2T", "13", "62",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "13", "48",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "13", "28",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "13", "48",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "13", "28",
	"CN", "2.4G", "20M", "OFDM", "2T", "13", "48",
	"FCC", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"MKK", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"IC", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"KCC", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"ACMA", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"CHILE", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"UKRAINE", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"MEXICO", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"CN", "2.4G", "20M", "OFDM", "2T", "14", "127",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "52",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "76",
	"IC", "2.4G", "20M", "HT", "1T", "01", "52",
	"KCC", "2.4G", "20M", "HT", "1T", "01", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "01", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "01", "52",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "01", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "01", "52",
	"CN", "2.4G", "20M", "HT", "1T", "01", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "60",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "76",
	"IC", "2.4G", "20M", "HT", "1T", "02", "60",
	"KCC", "2.4G", "20M", "HT", "1T", "02", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "02", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "02", "60",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "02", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "02", "60",
	"CN", "2.4G", "20M", "HT", "1T", "02", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "64",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "76",
	"IC", "2.4G", "20M", "HT", "1T", "03", "64",
	"KCC", "2.4G", "20M", "HT", "1T", "03", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "03", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "03", "64",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "03", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "03", "64",
	"CN", "2.4G", "20M", "HT", "1T", "03", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "68",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "76",
	"IC", "2.4G", "20M", "HT", "1T", "04", "68",
	"KCC", "2.4G", "20M", "HT", "1T", "04", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "04", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "04", "68",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "04", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "04", "68",
	"CN", "2.4G", "20M", "HT", "1T", "04", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "76",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "76",
	"IC", "2.4G", "20M", "HT", "1T", "05", "76",
	"KCC", "2.4G", "20M", "HT", "1T", "05", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "05", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "05", "76",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "05", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "05", "76",
	"CN", "2.4G", "20M", "HT", "1T", "05", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "76",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "76",
	"IC", "2.4G", "20M", "HT", "1T", "06", "76",
	"KCC", "2.4G", "20M", "HT", "1T", "06", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "06", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "06", "76",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "06", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "06", "76",
	"CN", "2.4G", "20M", "HT", "1T", "06", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "76",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "76",
	"IC", "2.4G", "20M", "HT", "1T", "07", "76",
	"KCC", "2.4G", "20M", "HT", "1T", "07", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "07", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "07", "76",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "07", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "07", "76",
	"CN", "2.4G", "20M", "HT", "1T", "07", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "68",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "76",
	"IC", "2.4G", "20M", "HT", "1T", "08", "68",
	"KCC", "2.4G", "20M", "HT", "1T", "08", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "08", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "08", "68",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "08", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "08", "68",
	"CN", "2.4G", "20M", "HT", "1T", "08", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "64",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "76",
	"IC", "2.4G", "20M", "HT", "1T", "09", "64",
	"KCC", "2.4G", "20M", "HT", "1T", "09", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "09", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "09", "64",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "09", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "09", "64",
	"CN", "2.4G", "20M", "HT", "1T", "09", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "60",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "76",
	"IC", "2.4G", "20M", "HT", "1T", "10", "60",
	"KCC", "2.4G", "20M", "HT", "1T", "10", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "10", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "10", "60",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "10", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "10", "60",
	"CN", "2.4G", "20M", "HT", "1T", "10", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "52",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "76",
	"IC", "2.4G", "20M", "HT", "1T", "11", "52",
	"KCC", "2.4G", "20M", "HT", "1T", "11", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "11", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "11", "52",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "11", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "11", "52",
	"CN", "2.4G", "20M", "HT", "1T", "11", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "76",
	"IC", "2.4G", "20M", "HT", "1T", "12", "40",
	"KCC", "2.4G", "20M", "HT", "1T", "12", "76",
	"ACMA", "2.4G", "20M", "HT", "1T", "12", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "12", "40",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "12", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "12", "40",
	"CN", "2.4G", "20M", "HT", "1T", "12", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "28",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "60",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "76",
	"IC", "2.4G", "20M", "HT", "1T", "13", "28",
	"KCC", "2.4G", "20M", "HT", "1T", "13", "72",
	"ACMA", "2.4G", "20M", "HT", "1T", "13", "60",
	"CHILE", "2.4G", "20M", "HT", "1T", "13", "28",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "13", "60",
	"MEXICO", "2.4G", "20M", "HT", "1T", "13", "28",
	"CN", "2.4G", "20M", "HT", "1T", "13", "60",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "127",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "127",
	"IC", "2.4G", "20M", "HT", "1T", "14", "127",
	"KCC", "2.4G", "20M", "HT", "1T", "14", "127",
	"ACMA", "2.4G", "20M", "HT", "1T", "14", "127",
	"CHILE", "2.4G", "20M", "HT", "1T", "14", "127",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "14", "127",
	"MEXICO", "2.4G", "20M", "HT", "1T", "14", "127",
	"CN", "2.4G", "20M", "HT", "1T", "14", "127",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "52",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "66",
	"IC", "2.4G", "20M", "HT", "2T", "01", "52",
	"KCC", "2.4G", "20M", "HT", "2T", "01", "68",
	"ACMA", "2.4G", "20M", "HT", "2T", "01", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "01", "52",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "01", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "01", "52",
	"CN", "2.4G", "20M", "HT", "2T", "01", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "60",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "66",
	"IC", "2.4G", "20M", "HT", "2T", "02", "60",
	"KCC", "2.4G", "20M", "HT", "2T", "02", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "02", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "02", "60",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "02", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "02", "60",
	"CN", "2.4G", "20M", "HT", "2T", "02", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "64",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "66",
	"IC", "2.4G", "20M", "HT", "2T", "03", "64",
	"KCC", "2.4G", "20M", "HT", "2T", "03", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "03", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "03", "64",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "03", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "03", "64",
	"CN", "2.4G", "20M", "HT", "2T", "03", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "68",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "66",
	"IC", "2.4G", "20M", "HT", "2T", "04", "68",
	"KCC", "2.4G", "20M", "HT", "2T", "04", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "04", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "04", "68",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "04", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "04", "68",
	"CN", "2.4G", "20M", "HT", "2T", "04", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "76",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "66",
	"IC", "2.4G", "20M", "HT", "2T", "05", "76",
	"KCC", "2.4G", "20M", "HT", "2T", "05", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "05", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "05", "76",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "05", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "05", "76",
	"CN", "2.4G", "20M", "HT", "2T", "05", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "76",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "66",
	"IC", "2.4G", "20M", "HT", "2T", "06", "76",
	"KCC", "2.4G", "20M", "HT", "2T", "06", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "06", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "06", "76",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "06", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "06", "76",
	"CN", "2.4G", "20M", "HT", "2T", "06", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "76",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "66",
	"IC", "2.4G", "20M", "HT", "2T", "07", "76",
	"KCC", "2.4G", "20M", "HT", "2T", "07", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "07", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "07", "76",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "07", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "07", "76",
	"CN", "2.4G", "20M", "HT", "2T", "07", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "68",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "66",
	"IC", "2.4G", "20M", "HT", "2T", "08", "68",
	"KCC", "2.4G", "20M", "HT", "2T", "08", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "08", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "08", "68",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "08", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "08", "68",
	"CN", "2.4G", "20M", "HT", "2T", "08", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "64",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "66",
	"IC", "2.4G", "20M", "HT", "2T", "09", "64",
	"KCC", "2.4G", "20M", "HT", "2T", "09", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "09", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "09", "64",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "09", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "09", "64",
	"CN", "2.4G", "20M", "HT", "2T", "09", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "60",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "66",
	"IC", "2.4G", "20M", "HT", "2T", "10", "60",
	"KCC", "2.4G", "20M", "HT", "2T", "10", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "10", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "10", "60",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "10", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "10", "60",
	"CN", "2.4G", "20M", "HT", "2T", "10", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "52",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "66",
	"IC", "2.4G", "20M", "HT", "2T", "11", "52",
	"KCC", "2.4G", "20M", "HT", "2T", "11", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "11", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "11", "52",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "11", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "11", "52",
	"CN", "2.4G", "20M", "HT", "2T", "11", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "40",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "66",
	"IC", "2.4G", "20M", "HT", "2T", "12", "40",
	"KCC", "2.4G", "20M", "HT", "2T", "12", "70",
	"ACMA", "2.4G", "20M", "HT", "2T", "12", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "12", "40",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "12", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "12", "40",
	"CN", "2.4G", "20M", "HT", "2T", "12", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "36",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "66",
	"IC", "2.4G", "20M", "HT", "2T", "13", "28",
	"KCC", "2.4G", "20M", "HT", "2T", "13", "62",
	"ACMA", "2.4G", "20M", "HT", "2T", "13", "36",
	"CHILE", "2.4G", "20M", "HT", "2T", "13", "28",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "13", "36",
	"MEXICO", "2.4G", "20M", "HT", "2T", "13", "28",
	"CN", "2.4G", "20M", "HT", "2T", "13", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "127",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "127",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "127",
	"IC", "2.4G", "20M", "HT", "2T", "14", "127",
	"KCC", "2.4G", "20M", "HT", "2T", "14", "127",
	"ACMA", "2.4G", "20M", "HT", "2T", "14", "127",
	"CHILE", "2.4G", "20M", "HT", "2T", "14", "127",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "14", "127",
	"MEXICO", "2.4G", "20M", "HT", "2T", "14", "127",
	"CN", "2.4G", "20M", "HT", "2T", "14", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "127",
	"IC", "2.4G", "40M", "HT", "1T", "01", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "01", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "01", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "01", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "01", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "01", "127",
	"CN", "2.4G", "40M", "HT", "1T", "01", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "127",
	"IC", "2.4G", "40M", "HT", "1T", "02", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "02", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "02", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "02", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "02", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "02", "127",
	"CN", "2.4G", "40M", "HT", "1T", "02", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "52",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "72",
	"IC", "2.4G", "40M", "HT", "1T", "03", "52",
	"KCC", "2.4G", "40M", "HT", "1T", "03", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "03", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "03", "52",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "03", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "03", "52",
	"CN", "2.4G", "40M", "HT", "1T", "03", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "52",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "72",
	"IC", "2.4G", "40M", "HT", "1T", "04", "52",
	"KCC", "2.4G", "40M", "HT", "1T", "04", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "04", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "04", "52",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "04", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "04", "52",
	"CN", "2.4G", "40M", "HT", "1T", "04", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "60",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "72",
	"IC", "2.4G", "40M", "HT", "1T", "05", "60",
	"KCC", "2.4G", "40M", "HT", "1T", "05", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "05", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "05", "60",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "05", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "05", "60",
	"CN", "2.4G", "40M", "HT", "1T", "05", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "64",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "72",
	"IC", "2.4G", "40M", "HT", "1T", "06", "64",
	"KCC", "2.4G", "40M", "HT", "1T", "06", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "06", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "06", "64",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "06", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "06", "64",
	"CN", "2.4G", "40M", "HT", "1T", "06", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "60",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "72",
	"IC", "2.4G", "40M", "HT", "1T", "07", "60",
	"KCC", "2.4G", "40M", "HT", "1T", "07", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "07", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "07", "60",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "07", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "07", "60",
	"CN", "2.4G", "40M", "HT", "1T", "07", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "52",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "72",
	"IC", "2.4G", "40M", "HT", "1T", "08", "52",
	"KCC", "2.4G", "40M", "HT", "1T", "08", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "08", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "08", "52",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "08", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "08", "52",
	"CN", "2.4G", "40M", "HT", "1T", "08", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "52",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "72",
	"IC", "2.4G", "40M", "HT", "1T", "09", "52",
	"KCC", "2.4G", "40M", "HT", "1T", "09", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "09", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "09", "52",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "09", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "09", "52",
	"CN", "2.4G", "40M", "HT", "1T", "09", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "40",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "72",
	"IC", "2.4G", "40M", "HT", "1T", "10", "40",
	"KCC", "2.4G", "40M", "HT", "1T", "10", "72",
	"ACMA", "2.4G", "40M", "HT", "1T", "10", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "10", "40",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "10", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "10", "40",
	"CN", "2.4G", "40M", "HT", "1T", "10", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "28",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "60",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "72",
	"IC", "2.4G", "40M", "HT", "1T", "11", "28",
	"KCC", "2.4G", "40M", "HT", "1T", "11", "70",
	"ACMA", "2.4G", "40M", "HT", "1T", "11", "60",
	"CHILE", "2.4G", "40M", "HT", "1T", "11", "28",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "11", "60",
	"MEXICO", "2.4G", "40M", "HT", "1T", "11", "28",
	"CN", "2.4G", "40M", "HT", "1T", "11", "60",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "127",
	"IC", "2.4G", "40M", "HT", "1T", "12", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "12", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "12", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "12", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "12", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "12", "127",
	"CN", "2.4G", "40M", "HT", "1T", "12", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "127",
	"IC", "2.4G", "40M", "HT", "1T", "13", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "13", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "13", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "13", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "13", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "13", "127",
	"CN", "2.4G", "40M", "HT", "1T", "13", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "127",
	"IC", "2.4G", "40M", "HT", "1T", "14", "127",
	"KCC", "2.4G", "40M", "HT", "1T", "14", "127",
	"ACMA", "2.4G", "40M", "HT", "1T", "14", "127",
	"CHILE", "2.4G", "40M", "HT", "1T", "14", "127",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "14", "127",
	"MEXICO", "2.4G", "40M", "HT", "1T", "14", "127",
	"CN", "2.4G", "40M", "HT", "1T", "14", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "127",
	"IC", "2.4G", "40M", "HT", "2T", "01", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "01", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "01", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "01", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "01", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "01", "127",
	"CN", "2.4G", "40M", "HT", "2T", "01", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "127",
	"IC", "2.4G", "40M", "HT", "2T", "02", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "02", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "02", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "02", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "02", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "02", "127",
	"CN", "2.4G", "40M", "HT", "2T", "02", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "48",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "66",
	"IC", "2.4G", "40M", "HT", "2T", "03", "48",
	"KCC", "2.4G", "40M", "HT", "2T", "03", "66",
	"ACMA", "2.4G", "40M", "HT", "2T", "03", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "03", "48",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "03", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "03", "48",
	"CN", "2.4G", "40M", "HT", "2T", "03", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "48",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "66",
	"IC", "2.4G", "40M", "HT", "2T", "04", "48",
	"KCC", "2.4G", "40M", "HT", "2T", "04", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "04", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "04", "48",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "04", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "04", "48",
	"CN", "2.4G", "40M", "HT", "2T", "04", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "60",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "66",
	"IC", "2.4G", "40M", "HT", "2T", "05", "60",
	"KCC", "2.4G", "40M", "HT", "2T", "05", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "05", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "05", "60",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "05", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "05", "60",
	"CN", "2.4G", "40M", "HT", "2T", "05", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "64",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "66",
	"IC", "2.4G", "40M", "HT", "2T", "06", "64",
	"KCC", "2.4G", "40M", "HT", "2T", "06", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "06", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "06", "64",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "06", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "06", "64",
	"CN", "2.4G", "40M", "HT", "2T", "06", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "60",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "66",
	"IC", "2.4G", "40M", "HT", "2T", "07", "60",
	"KCC", "2.4G", "40M", "HT", "2T", "07", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "07", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "07", "60",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "07", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "07", "60",
	"CN", "2.4G", "40M", "HT", "2T", "07", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "52",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "66",
	"IC", "2.4G", "40M", "HT", "2T", "08", "52",
	"KCC", "2.4G", "40M", "HT", "2T", "08", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "08", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "08", "52",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "08", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "08", "52",
	"CN", "2.4G", "40M", "HT", "2T", "08", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "52",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "66",
	"IC", "2.4G", "40M", "HT", "2T", "09", "52",
	"KCC", "2.4G", "40M", "HT", "2T", "09", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "09", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "09", "52",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "09", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "09", "52",
	"CN", "2.4G", "40M", "HT", "2T", "09", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "40",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "66",
	"IC", "2.4G", "40M", "HT", "2T", "10", "40",
	"KCC", "2.4G", "40M", "HT", "2T", "10", "70",
	"ACMA", "2.4G", "40M", "HT", "2T", "10", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "10", "40",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "10", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "10", "40",
	"CN", "2.4G", "40M", "HT", "2T", "10", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "36",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "66",
	"IC", "2.4G", "40M", "HT", "2T", "11", "26",
	"KCC", "2.4G", "40M", "HT", "2T", "11", "66",
	"ACMA", "2.4G", "40M", "HT", "2T", "11", "36",
	"CHILE", "2.4G", "40M", "HT", "2T", "11", "26",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "11", "36",
	"MEXICO", "2.4G", "40M", "HT", "2T", "11", "26",
	"CN", "2.4G", "40M", "HT", "2T", "11", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "127",
	"IC", "2.4G", "40M", "HT", "2T", "12", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "12", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "12", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "12", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "12", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "12", "127",
	"CN", "2.4G", "40M", "HT", "2T", "12", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "127",
	"IC", "2.4G", "40M", "HT", "2T", "13", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "13", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "13", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "13", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "13", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "13", "127",
	"CN", "2.4G", "40M", "HT", "2T", "13", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "127",
	"IC", "2.4G", "40M", "HT", "2T", "14", "127",
	"KCC", "2.4G", "40M", "HT", "2T", "14", "127",
	"ACMA", "2.4G", "40M", "HT", "2T", "14", "127",
	"CHILE", "2.4G", "40M", "HT", "2T", "14", "127",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "14", "127",
	"MEXICO", "2.4G", "40M", "HT", "2T", "14", "127",
	"CN", "2.4G", "40M", "HT", "2T", "14", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "74",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "60",
	"IC", "5G", "20M", "OFDM", "1T", "36", "62",
	"KCC", "5G", "20M", "OFDM", "1T", "36", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "36", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "36", "64",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "36", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "36", "62",
	"CN", "5G", "20M", "OFDM", "1T", "36", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "62",
	"IC", "5G", "20M", "OFDM", "1T", "40", "62",
	"KCC", "5G", "20M", "OFDM", "1T", "40", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "40", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "40", "64",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "40", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "40", "62",
	"CN", "5G", "20M", "OFDM", "1T", "40", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "62",
	"IC", "5G", "20M", "OFDM", "1T", "44", "62",
	"KCC", "5G", "20M", "OFDM", "1T", "44", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "44", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "44", "64",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "44", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "44", "62",
	"CN", "5G", "20M", "OFDM", "1T", "44", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "62",
	"IC", "5G", "20M", "OFDM", "1T", "48", "62",
	"KCC", "5G", "20M", "OFDM", "1T", "48", "54",
	"ACMA", "5G", "20M", "OFDM", "1T", "48", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "48", "64",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "48", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "48", "62",
	"CN", "5G", "20M", "OFDM", "1T", "48", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "62",
	"IC", "5G", "20M", "OFDM", "1T", "52", "64",
	"KCC", "5G", "20M", "OFDM", "1T", "52", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "52", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "52", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "52", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "52", "76",
	"CN", "5G", "20M", "OFDM", "1T", "52", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "62",
	"IC", "5G", "20M", "OFDM", "1T", "56", "64",
	"KCC", "5G", "20M", "OFDM", "1T", "56", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "56", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "56", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "56", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "56", "76",
	"CN", "5G", "20M", "OFDM", "1T", "56", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "62",
	"IC", "5G", "20M", "OFDM", "1T", "60", "64",
	"KCC", "5G", "20M", "OFDM", "1T", "60", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "60", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "60", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "60", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "60", "76",
	"CN", "5G", "20M", "OFDM", "1T", "60", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "74",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "60",
	"IC", "5G", "20M", "OFDM", "1T", "64", "64",
	"KCC", "5G", "20M", "OFDM", "1T", "64", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "64", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "64", "74",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "64", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "64", "74",
	"CN", "5G", "20M", "OFDM", "1T", "64", "62",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "72",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "76",
	"IC", "5G", "20M", "OFDM", "1T", "100", "72",
	"KCC", "5G", "20M", "OFDM", "1T", "100", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "100", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "100", "72",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "100", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "100", "72",
	"CN", "5G", "20M", "OFDM", "1T", "100", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "76",
	"IC", "5G", "20M", "OFDM", "1T", "104", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "104", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "104", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "104", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "104", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "104", "76",
	"CN", "5G", "20M", "OFDM", "1T", "104", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "76",
	"IC", "5G", "20M", "OFDM", "1T", "108", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "108", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "108", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "108", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "108", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "108", "76",
	"CN", "5G", "20M", "OFDM", "1T", "108", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "76",
	"IC", "5G", "20M", "OFDM", "1T", "112", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "112", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "112", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "112", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "112", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "112", "76",
	"CN", "5G", "20M", "OFDM", "1T", "112", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "76",
	"IC", "5G", "20M", "OFDM", "1T", "116", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "116", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "116", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "116", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "116", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "116", "76",
	"CN", "5G", "20M", "OFDM", "1T", "116", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "76",
	"IC", "5G", "20M", "OFDM", "1T", "120", "127",
	"KCC", "5G", "20M", "OFDM", "1T", "120", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "120", "127",
	"CHILE", "5G", "20M", "OFDM", "1T", "120", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "120", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "120", "76",
	"CN", "5G", "20M", "OFDM", "1T", "120", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "76",
	"IC", "5G", "20M", "OFDM", "1T", "124", "127",
	"KCC", "5G", "20M", "OFDM", "1T", "124", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "124", "127",
	"CHILE", "5G", "20M", "OFDM", "1T", "124", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "124", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "124", "76",
	"CN", "5G", "20M", "OFDM", "1T", "124", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "76",
	"IC", "5G", "20M", "OFDM", "1T", "128", "127",
	"KCC", "5G", "20M", "OFDM", "1T", "128", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "128", "127",
	"CHILE", "5G", "20M", "OFDM", "1T", "128", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "128", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "128", "76",
	"CN", "5G", "20M", "OFDM", "1T", "128", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "76",
	"IC", "5G", "20M", "OFDM", "1T", "132", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "132", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "132", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "132", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "132", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "132", "76",
	"CN", "5G", "20M", "OFDM", "1T", "132", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "76",
	"IC", "5G", "20M", "OFDM", "1T", "136", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "136", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "136", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "136", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "136", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "136", "76",
	"CN", "5G", "20M", "OFDM", "1T", "136", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "72",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "62",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "76",
	"IC", "5G", "20M", "OFDM", "1T", "140", "72",
	"KCC", "5G", "20M", "OFDM", "1T", "140", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "140", "62",
	"CHILE", "5G", "20M", "OFDM", "1T", "140", "72",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "140", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "140", "72",
	"CN", "5G", "20M", "OFDM", "1T", "140", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "127",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "127",
	"IC", "5G", "20M", "OFDM", "1T", "144", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "144", "76",
	"ACMA", "5G", "20M", "OFDM", "1T", "144", "127",
	"CHILE", "5G", "20M", "OFDM", "1T", "144", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "144", "127",
	"MEXICO", "5G", "20M", "OFDM", "1T", "144", "76",
	"CN", "5G", "20M", "OFDM", "1T", "144", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "127",
	"IC", "5G", "20M", "OFDM", "1T", "149", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "149", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "149", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "149", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "149", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "149", "76",
	"CN", "5G", "20M", "OFDM", "1T", "149", "-128",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "127",
	"IC", "5G", "20M", "OFDM", "1T", "153", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "153", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "153", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "153", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "153", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "153", "76",
	"CN", "5G", "20M", "OFDM", "1T", "153", "-128",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "127",
	"IC", "5G", "20M", "OFDM", "1T", "157", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "157", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "157", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "157", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "157", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "157", "76",
	"CN", "5G", "20M", "OFDM", "1T", "157", "-128",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "127",
	"IC", "5G", "20M", "OFDM", "1T", "161", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "161", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "161", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "161", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "161", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "161", "76",
	"CN", "5G", "20M", "OFDM", "1T", "161", "-128",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "76",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "-128",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "127",
	"IC", "5G", "20M", "OFDM", "1T", "165", "76",
	"KCC", "5G", "20M", "OFDM", "1T", "165", "74",
	"ACMA", "5G", "20M", "OFDM", "1T", "165", "76",
	"CHILE", "5G", "20M", "OFDM", "1T", "165", "76",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "165", "54",
	"MEXICO", "5G", "20M", "OFDM", "1T", "165", "76",
	"CN", "5G", "20M", "OFDM", "1T", "165", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "36", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "36", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "36", "48",
	"IC", "5G", "20M", "OFDM", "2T", "36", "40",
	"KCC", "5G", "20M", "OFDM", "2T", "36", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "36", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "36", "52",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "36", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "36", "50",
	"CN", "5G", "20M", "OFDM", "2T", "36", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "40", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "40", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "40", "50",
	"IC", "5G", "20M", "OFDM", "2T", "40", "40",
	"KCC", "5G", "20M", "OFDM", "2T", "40", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "40", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "40", "52",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "40", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "40", "50",
	"CN", "5G", "20M", "OFDM", "2T", "40", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "44", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "44", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "44", "50",
	"IC", "5G", "20M", "OFDM", "2T", "44", "40",
	"KCC", "5G", "20M", "OFDM", "2T", "44", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "44", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "44", "52",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "44", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "44", "50",
	"CN", "5G", "20M", "OFDM", "2T", "44", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "48", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "48", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "48", "50",
	"IC", "5G", "20M", "OFDM", "2T", "48", "40",
	"KCC", "5G", "20M", "OFDM", "2T", "48", "36",
	"ACMA", "5G", "20M", "OFDM", "2T", "48", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "48", "52",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "48", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "48", "50",
	"CN", "5G", "20M", "OFDM", "2T", "48", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "52", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "52", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "52", "50",
	"IC", "5G", "20M", "OFDM", "2T", "52", "52",
	"KCC", "5G", "20M", "OFDM", "2T", "52", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "52", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "52", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "52", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "52", "68",
	"CN", "5G", "20M", "OFDM", "2T", "52", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "56", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "56", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "56", "50",
	"IC", "5G", "20M", "OFDM", "2T", "56", "52",
	"KCC", "5G", "20M", "OFDM", "2T", "56", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "56", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "56", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "56", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "56", "68",
	"CN", "5G", "20M", "OFDM", "2T", "56", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "60", "66",
	"ETSI", "5G", "20M", "OFDM", "2T", "60", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "60", "50",
	"IC", "5G", "20M", "OFDM", "2T", "60", "52",
	"KCC", "5G", "20M", "OFDM", "2T", "60", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "60", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "60", "66",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "60", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "60", "66",
	"CN", "5G", "20M", "OFDM", "2T", "60", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "64", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "64", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "64", "48",
	"IC", "5G", "20M", "OFDM", "2T", "64", "52",
	"KCC", "5G", "20M", "OFDM", "2T", "64", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "64", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "64", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "64", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "64", "68",
	"CN", "5G", "20M", "OFDM", "2T", "64", "50",
	"FCC", "5G", "20M", "OFDM", "2T", "100", "60",
	"ETSI", "5G", "20M", "OFDM", "2T", "100", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "100", "70",
	"IC", "5G", "20M", "OFDM", "2T", "100", "60",
	"KCC", "5G", "20M", "OFDM", "2T", "100", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "100", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "100", "60",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "100", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "100", "60",
	"CN", "5G", "20M", "OFDM", "2T", "100", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "104", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "104", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "104", "70",
	"IC", "5G", "20M", "OFDM", "2T", "104", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "104", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "104", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "104", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "104", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "104", "68",
	"CN", "5G", "20M", "OFDM", "2T", "104", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "108", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "108", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "108", "70",
	"IC", "5G", "20M", "OFDM", "2T", "108", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "108", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "108", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "108", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "108", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "108", "68",
	"CN", "5G", "20M", "OFDM", "2T", "108", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "112", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "112", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "112", "70",
	"IC", "5G", "20M", "OFDM", "2T", "112", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "112", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "112", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "112", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "112", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "112", "68",
	"CN", "5G", "20M", "OFDM", "2T", "112", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "116", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "116", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "116", "70",
	"IC", "5G", "20M", "OFDM", "2T", "116", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "116", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "116", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "116", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "116", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "116", "68",
	"CN", "5G", "20M", "OFDM", "2T", "116", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "120", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "120", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "120", "70",
	"IC", "5G", "20M", "OFDM", "2T", "120", "127",
	"KCC", "5G", "20M", "OFDM", "2T", "120", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "120", "127",
	"CHILE", "5G", "20M", "OFDM", "2T", "120", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "120", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "120", "68",
	"CN", "5G", "20M", "OFDM", "2T", "120", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "124", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "124", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "124", "70",
	"IC", "5G", "20M", "OFDM", "2T", "124", "127",
	"KCC", "5G", "20M", "OFDM", "2T", "124", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "124", "127",
	"CHILE", "5G", "20M", "OFDM", "2T", "124", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "124", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "124", "68",
	"CN", "5G", "20M", "OFDM", "2T", "124", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "128", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "128", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "128", "70",
	"IC", "5G", "20M", "OFDM", "2T", "128", "127",
	"KCC", "5G", "20M", "OFDM", "2T", "128", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "128", "127",
	"CHILE", "5G", "20M", "OFDM", "2T", "128", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "128", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "128", "68",
	"CN", "5G", "20M", "OFDM", "2T", "128", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "132", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "132", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "132", "70",
	"IC", "5G", "20M", "OFDM", "2T", "132", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "132", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "132", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "132", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "132", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "132", "68",
	"CN", "5G", "20M", "OFDM", "2T", "132", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "136", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "136", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "136", "70",
	"IC", "5G", "20M", "OFDM", "2T", "136", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "136", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "136", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "136", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "136", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "136", "68",
	"CN", "5G", "20M", "OFDM", "2T", "136", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "140", "60",
	"ETSI", "5G", "20M", "OFDM", "2T", "140", "50",
	"MKK", "5G", "20M", "OFDM", "2T", "140", "70",
	"IC", "5G", "20M", "OFDM", "2T", "140", "60",
	"KCC", "5G", "20M", "OFDM", "2T", "140", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "140", "50",
	"CHILE", "5G", "20M", "OFDM", "2T", "140", "60",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "140", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "140", "60",
	"CN", "5G", "20M", "OFDM", "2T", "140", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "144", "68",
	"ETSI", "5G", "20M", "OFDM", "2T", "144", "127",
	"MKK", "5G", "20M", "OFDM", "2T", "144", "127",
	"IC", "5G", "20M", "OFDM", "2T", "144", "68",
	"KCC", "5G", "20M", "OFDM", "2T", "144", "66",
	"ACMA", "5G", "20M", "OFDM", "2T", "144", "127",
	"CHILE", "5G", "20M", "OFDM", "2T", "144", "68",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "144", "127",
	"MEXICO", "5G", "20M", "OFDM", "2T", "144", "68",
	"CN", "5G", "20M", "OFDM", "2T", "144", "127",
	"FCC", "5G", "20M", "OFDM", "2T", "149", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "149", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "149", "127",
	"IC", "5G", "20M", "OFDM", "2T", "149", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "149", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "149", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "149", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "149", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "149", "72",
	"CN", "5G", "20M", "OFDM", "2T", "149", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "153", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "153", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "153", "127",
	"IC", "5G", "20M", "OFDM", "2T", "153", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "153", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "153", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "153", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "153", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "153", "76",
	"CN", "5G", "20M", "OFDM", "2T", "153", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "157", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "157", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "157", "127",
	"IC", "5G", "20M", "OFDM", "2T", "157", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "157", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "157", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "157", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "157", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "157", "76",
	"CN", "5G", "20M", "OFDM", "2T", "157", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "161", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "161", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "161", "127",
	"IC", "5G", "20M", "OFDM", "2T", "161", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "161", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "161", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "161", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "161", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "161", "76",
	"CN", "5G", "20M", "OFDM", "2T", "161", "-128",
	"FCC", "5G", "20M", "OFDM", "2T", "165", "76",
	"ETSI", "5G", "20M", "OFDM", "2T", "165", "-128",
	"MKK", "5G", "20M", "OFDM", "2T", "165", "127",
	"IC", "5G", "20M", "OFDM", "2T", "165", "76",
	"KCC", "5G", "20M", "OFDM", "2T", "165", "64",
	"ACMA", "5G", "20M", "OFDM", "2T", "165", "76",
	"CHILE", "5G", "20M", "OFDM", "2T", "165", "76",
	"UKRAINE", "5G", "20M", "OFDM", "2T", "165", "42",
	"MEXICO", "5G", "20M", "OFDM", "2T", "165", "76",
	"CN", "5G", "20M", "OFDM", "2T", "165", "-128",
	"FCC", "5G", "20M", "HT", "1T", "36", "72",
	"ETSI", "5G", "20M", "HT", "1T", "36", "62",
	"MKK", "5G", "20M", "HT", "1T", "36", "62",
	"IC", "5G", "20M", "HT", "1T", "36", "62",
	"KCC", "5G", "20M", "HT", "1T", "36", "76",
	"ACMA", "5G", "20M", "HT", "1T", "36", "62",
	"CHILE", "5G", "20M", "HT", "1T", "36", "64",
	"UKRAINE", "5G", "20M", "HT", "1T", "36", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "36", "62",
	"CN", "5G", "20M", "HT", "1T", "36", "62",
	"FCC", "5G", "20M", "HT", "1T", "40", "76",
	"ETSI", "5G", "20M", "HT", "1T", "40", "62",
	"MKK", "5G", "20M", "HT", "1T", "40", "62",
	"IC", "5G", "20M", "HT", "1T", "40", "62",
	"KCC", "5G", "20M", "HT", "1T", "40", "76",
	"ACMA", "5G", "20M", "HT", "1T", "40", "62",
	"CHILE", "5G", "20M", "HT", "1T", "40", "64",
	"UKRAINE", "5G", "20M", "HT", "1T", "40", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "40", "62",
	"CN", "5G", "20M", "HT", "1T", "40", "62",
	"FCC", "5G", "20M", "HT", "1T", "44", "76",
	"ETSI", "5G", "20M", "HT", "1T", "44", "62",
	"MKK", "5G", "20M", "HT", "1T", "44", "62",
	"IC", "5G", "20M", "HT", "1T", "44", "62",
	"KCC", "5G", "20M", "HT", "1T", "44", "76",
	"ACMA", "5G", "20M", "HT", "1T", "44", "62",
	"CHILE", "5G", "20M", "HT", "1T", "44", "64",
	"UKRAINE", "5G", "20M", "HT", "1T", "44", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "44", "62",
	"CN", "5G", "20M", "HT", "1T", "44", "62",
	"FCC", "5G", "20M", "HT", "1T", "48", "76",
	"ETSI", "5G", "20M", "HT", "1T", "48", "62",
	"MKK", "5G", "20M", "HT", "1T", "48", "62",
	"IC", "5G", "20M", "HT", "1T", "48", "62",
	"KCC", "5G", "20M", "HT", "1T", "48", "54",
	"ACMA", "5G", "20M", "HT", "1T", "48", "62",
	"CHILE", "5G", "20M", "HT", "1T", "48", "64",
	"UKRAINE", "5G", "20M", "HT", "1T", "48", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "48", "62",
	"CN", "5G", "20M", "HT", "1T", "48", "62",
	"FCC", "5G", "20M", "HT", "1T", "52", "76",
	"ETSI", "5G", "20M", "HT", "1T", "52", "62",
	"MKK", "5G", "20M", "HT", "1T", "52", "62",
	"IC", "5G", "20M", "HT", "1T", "52", "64",
	"KCC", "5G", "20M", "HT", "1T", "52", "76",
	"ACMA", "5G", "20M", "HT", "1T", "52", "62",
	"CHILE", "5G", "20M", "HT", "1T", "52", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "52", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "52", "76",
	"CN", "5G", "20M", "HT", "1T", "52", "62",
	"FCC", "5G", "20M", "HT", "1T", "56", "76",
	"ETSI", "5G", "20M", "HT", "1T", "56", "62",
	"MKK", "5G", "20M", "HT", "1T", "56", "62",
	"IC", "5G", "20M", "HT", "1T", "56", "64",
	"KCC", "5G", "20M", "HT", "1T", "56", "76",
	"ACMA", "5G", "20M", "HT", "1T", "56", "62",
	"CHILE", "5G", "20M", "HT", "1T", "56", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "56", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "56", "76",
	"CN", "5G", "20M", "HT", "1T", "56", "62",
	"FCC", "5G", "20M", "HT", "1T", "60", "76",
	"ETSI", "5G", "20M", "HT", "1T", "60", "62",
	"MKK", "5G", "20M", "HT", "1T", "60", "62",
	"IC", "5G", "20M", "HT", "1T", "60", "64",
	"KCC", "5G", "20M", "HT", "1T", "60", "76",
	"ACMA", "5G", "20M", "HT", "1T", "60", "62",
	"CHILE", "5G", "20M", "HT", "1T", "60", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "60", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "60", "76",
	"CN", "5G", "20M", "HT", "1T", "60", "62",
	"FCC", "5G", "20M", "HT", "1T", "64", "74",
	"ETSI", "5G", "20M", "HT", "1T", "64", "62",
	"MKK", "5G", "20M", "HT", "1T", "64", "60",
	"IC", "5G", "20M", "HT", "1T", "64", "64",
	"KCC", "5G", "20M", "HT", "1T", "64", "74",
	"ACMA", "5G", "20M", "HT", "1T", "64", "62",
	"CHILE", "5G", "20M", "HT", "1T", "64", "74",
	"UKRAINE", "5G", "20M", "HT", "1T", "64", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "64", "74",
	"CN", "5G", "20M", "HT", "1T", "64", "62",
	"FCC", "5G", "20M", "HT", "1T", "100", "70",
	"ETSI", "5G", "20M", "HT", "1T", "100", "62",
	"MKK", "5G", "20M", "HT", "1T", "100", "76",
	"IC", "5G", "20M", "HT", "1T", "100", "70",
	"KCC", "5G", "20M", "HT", "1T", "100", "76",
	"ACMA", "5G", "20M", "HT", "1T", "100", "62",
	"CHILE", "5G", "20M", "HT", "1T", "100", "70",
	"UKRAINE", "5G", "20M", "HT", "1T", "100", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "100", "70",
	"CN", "5G", "20M", "HT", "1T", "100", "127",
	"FCC", "5G", "20M", "HT", "1T", "104", "76",
	"ETSI", "5G", "20M", "HT", "1T", "104", "62",
	"MKK", "5G", "20M", "HT", "1T", "104", "76",
	"IC", "5G", "20M", "HT", "1T", "104", "76",
	"KCC", "5G", "20M", "HT", "1T", "104", "76",
	"ACMA", "5G", "20M", "HT", "1T", "104", "62",
	"CHILE", "5G", "20M", "HT", "1T", "104", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "104", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "104", "76",
	"CN", "5G", "20M", "HT", "1T", "104", "127",
	"FCC", "5G", "20M", "HT", "1T", "108", "76",
	"ETSI", "5G", "20M", "HT", "1T", "108", "62",
	"MKK", "5G", "20M", "HT", "1T", "108", "76",
	"IC", "5G", "20M", "HT", "1T", "108", "76",
	"KCC", "5G", "20M", "HT", "1T", "108", "76",
	"ACMA", "5G", "20M", "HT", "1T", "108", "62",
	"CHILE", "5G", "20M", "HT", "1T", "108", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "108", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "108", "76",
	"CN", "5G", "20M", "HT", "1T", "108", "127",
	"FCC", "5G", "20M", "HT", "1T", "112", "76",
	"ETSI", "5G", "20M", "HT", "1T", "112", "62",
	"MKK", "5G", "20M", "HT", "1T", "112", "76",
	"IC", "5G", "20M", "HT", "1T", "112", "76",
	"KCC", "5G", "20M", "HT", "1T", "112", "76",
	"ACMA", "5G", "20M", "HT", "1T", "112", "62",
	"CHILE", "5G", "20M", "HT", "1T", "112", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "112", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "112", "76",
	"CN", "5G", "20M", "HT", "1T", "112", "127",
	"FCC", "5G", "20M", "HT", "1T", "116", "76",
	"ETSI", "5G", "20M", "HT", "1T", "116", "62",
	"MKK", "5G", "20M", "HT", "1T", "116", "76",
	"IC", "5G", "20M", "HT", "1T", "116", "76",
	"KCC", "5G", "20M", "HT", "1T", "116", "76",
	"ACMA", "5G", "20M", "HT", "1T", "116", "62",
	"CHILE", "5G", "20M", "HT", "1T", "116", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "116", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "116", "76",
	"CN", "5G", "20M", "HT", "1T", "116", "127",
	"FCC", "5G", "20M", "HT", "1T", "120", "76",
	"ETSI", "5G", "20M", "HT", "1T", "120", "62",
	"MKK", "5G", "20M", "HT", "1T", "120", "76",
	"IC", "5G", "20M", "HT", "1T", "120", "127",
	"KCC", "5G", "20M", "HT", "1T", "120", "76",
	"ACMA", "5G", "20M", "HT", "1T", "120", "127",
	"CHILE", "5G", "20M", "HT", "1T", "120", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "120", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "120", "76",
	"CN", "5G", "20M", "HT", "1T", "120", "127",
	"FCC", "5G", "20M", "HT", "1T", "124", "76",
	"ETSI", "5G", "20M", "HT", "1T", "124", "62",
	"MKK", "5G", "20M", "HT", "1T", "124", "76",
	"IC", "5G", "20M", "HT", "1T", "124", "127",
	"KCC", "5G", "20M", "HT", "1T", "124", "76",
	"ACMA", "5G", "20M", "HT", "1T", "124", "127",
	"CHILE", "5G", "20M", "HT", "1T", "124", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "124", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "124", "76",
	"CN", "5G", "20M", "HT", "1T", "124", "127",
	"FCC", "5G", "20M", "HT", "1T", "128", "76",
	"ETSI", "5G", "20M", "HT", "1T", "128", "62",
	"MKK", "5G", "20M", "HT", "1T", "128", "76",
	"IC", "5G", "20M", "HT", "1T", "128", "127",
	"KCC", "5G", "20M", "HT", "1T", "128", "76",
	"ACMA", "5G", "20M", "HT", "1T", "128", "127",
	"CHILE", "5G", "20M", "HT", "1T", "128", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "128", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "128", "76",
	"CN", "5G", "20M", "HT", "1T", "128", "127",
	"FCC", "5G", "20M", "HT", "1T", "132", "76",
	"ETSI", "5G", "20M", "HT", "1T", "132", "62",
	"MKK", "5G", "20M", "HT", "1T", "132", "76",
	"IC", "5G", "20M", "HT", "1T", "132", "76",
	"KCC", "5G", "20M", "HT", "1T", "132", "76",
	"ACMA", "5G", "20M", "HT", "1T", "132", "62",
	"CHILE", "5G", "20M", "HT", "1T", "132", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "132", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "132", "76",
	"CN", "5G", "20M", "HT", "1T", "132", "127",
	"FCC", "5G", "20M", "HT", "1T", "136", "76",
	"ETSI", "5G", "20M", "HT", "1T", "136", "62",
	"MKK", "5G", "20M", "HT", "1T", "136", "76",
	"IC", "5G", "20M", "HT", "1T", "136", "76",
	"KCC", "5G", "20M", "HT", "1T", "136", "76",
	"ACMA", "5G", "20M", "HT", "1T", "136", "62",
	"CHILE", "5G", "20M", "HT", "1T", "136", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "136", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "136", "76",
	"CN", "5G", "20M", "HT", "1T", "136", "127",
	"FCC", "5G", "20M", "HT", "1T", "140", "70",
	"ETSI", "5G", "20M", "HT", "1T", "140", "62",
	"MKK", "5G", "20M", "HT", "1T", "140", "76",
	"IC", "5G", "20M", "HT", "1T", "140", "70",
	"KCC", "5G", "20M", "HT", "1T", "140", "76",
	"ACMA", "5G", "20M", "HT", "1T", "140", "62",
	"CHILE", "5G", "20M", "HT", "1T", "140", "70",
	"UKRAINE", "5G", "20M", "HT", "1T", "140", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "140", "70",
	"CN", "5G", "20M", "HT", "1T", "140", "127",
	"FCC", "5G", "20M", "HT", "1T", "144", "76",
	"ETSI", "5G", "20M", "HT", "1T", "144", "127",
	"MKK", "5G", "20M", "HT", "1T", "144", "127",
	"IC", "5G", "20M", "HT", "1T", "144", "76",
	"KCC", "5G", "20M", "HT", "1T", "144", "76",
	"ACMA", "5G", "20M", "HT", "1T", "144", "127",
	"CHILE", "5G", "20M", "HT", "1T", "144", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "144", "127",
	"MEXICO", "5G", "20M", "HT", "1T", "144", "76",
	"CN", "5G", "20M", "HT", "1T", "144", "127",
	"FCC", "5G", "20M", "HT", "1T", "149", "76",
	"ETSI", "5G", "20M", "HT", "1T", "149", "-128",
	"MKK", "5G", "20M", "HT", "1T", "149", "127",
	"IC", "5G", "20M", "HT", "1T", "149", "76",
	"KCC", "5G", "20M", "HT", "1T", "149", "74",
	"ACMA", "5G", "20M", "HT", "1T", "149", "76",
	"CHILE", "5G", "20M", "HT", "1T", "149", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "149", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "149", "76",
	"CN", "5G", "20M", "HT", "1T", "149", "-128",
	"FCC", "5G", "20M", "HT", "1T", "153", "76",
	"ETSI", "5G", "20M", "HT", "1T", "153", "-128",
	"MKK", "5G", "20M", "HT", "1T", "153", "127",
	"IC", "5G", "20M", "HT", "1T", "153", "76",
	"KCC", "5G", "20M", "HT", "1T", "153", "74",
	"ACMA", "5G", "20M", "HT", "1T", "153", "76",
	"CHILE", "5G", "20M", "HT", "1T", "153", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "153", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "153", "76",
	"CN", "5G", "20M", "HT", "1T", "153", "-128",
	"FCC", "5G", "20M", "HT", "1T", "157", "76",
	"ETSI", "5G", "20M", "HT", "1T", "157", "-128",
	"MKK", "5G", "20M", "HT", "1T", "157", "127",
	"IC", "5G", "20M", "HT", "1T", "157", "76",
	"KCC", "5G", "20M", "HT", "1T", "157", "74",
	"ACMA", "5G", "20M", "HT", "1T", "157", "76",
	"CHILE", "5G", "20M", "HT", "1T", "157", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "157", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "157", "76",
	"CN", "5G", "20M", "HT", "1T", "157", "-128",
	"FCC", "5G", "20M", "HT", "1T", "161", "76",
	"ETSI", "5G", "20M", "HT", "1T", "161", "-128",
	"MKK", "5G", "20M", "HT", "1T", "161", "127",
	"IC", "5G", "20M", "HT", "1T", "161", "76",
	"KCC", "5G", "20M", "HT", "1T", "161", "74",
	"ACMA", "5G", "20M", "HT", "1T", "161", "76",
	"CHILE", "5G", "20M", "HT", "1T", "161", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "161", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "161", "76",
	"CN", "5G", "20M", "HT", "1T", "161", "-128",
	"FCC", "5G", "20M", "HT", "1T", "165", "76",
	"ETSI", "5G", "20M", "HT", "1T", "165", "-128",
	"MKK", "5G", "20M", "HT", "1T", "165", "127",
	"IC", "5G", "20M", "HT", "1T", "165", "76",
	"KCC", "5G", "20M", "HT", "1T", "165", "74",
	"ACMA", "5G", "20M", "HT", "1T", "165", "76",
	"CHILE", "5G", "20M", "HT", "1T", "165", "76",
	"UKRAINE", "5G", "20M", "HT", "1T", "165", "54",
	"MEXICO", "5G", "20M", "HT", "1T", "165", "76",
	"CN", "5G", "20M", "HT", "1T", "165", "-128",
	"FCC", "5G", "20M", "HT", "2T", "36", "68",
	"ETSI", "5G", "20M", "HT", "2T", "36", "38",
	"MKK", "5G", "20M", "HT", "2T", "36", "50",
	"IC", "5G", "20M", "HT", "2T", "36", "38",
	"KCC", "5G", "20M", "HT", "2T", "36", "66",
	"ACMA", "5G", "20M", "HT", "2T", "36", "38",
	"CHILE", "5G", "20M", "HT", "2T", "36", "52",
	"UKRAINE", "5G", "20M", "HT", "2T", "36", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "36", "50",
	"CN", "5G", "20M", "HT", "2T", "36", "38",
	"FCC", "5G", "20M", "HT", "2T", "40", "68",
	"ETSI", "5G", "20M", "HT", "2T", "40", "38",
	"MKK", "5G", "20M", "HT", "2T", "40", "50",
	"IC", "5G", "20M", "HT", "2T", "40", "38",
	"KCC", "5G", "20M", "HT", "2T", "40", "66",
	"ACMA", "5G", "20M", "HT", "2T", "40", "38",
	"CHILE", "5G", "20M", "HT", "2T", "40", "52",
	"UKRAINE", "5G", "20M", "HT", "2T", "40", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "40", "50",
	"CN", "5G", "20M", "HT", "2T", "40", "38",
	"FCC", "5G", "20M", "HT", "2T", "44", "68",
	"ETSI", "5G", "20M", "HT", "2T", "44", "38",
	"MKK", "5G", "20M", "HT", "2T", "44", "50",
	"IC", "5G", "20M", "HT", "2T", "44", "38",
	"KCC", "5G", "20M", "HT", "2T", "44", "66",
	"ACMA", "5G", "20M", "HT", "2T", "44", "38",
	"CHILE", "5G", "20M", "HT", "2T", "44", "52",
	"UKRAINE", "5G", "20M", "HT", "2T", "44", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "44", "50",
	"CN", "5G", "20M", "HT", "2T", "44", "38",
	"FCC", "5G", "20M", "HT", "2T", "48", "68",
	"ETSI", "5G", "20M", "HT", "2T", "48", "38",
	"MKK", "5G", "20M", "HT", "2T", "48", "50",
	"IC", "5G", "20M", "HT", "2T", "48", "38",
	"KCC", "5G", "20M", "HT", "2T", "48", "36",
	"ACMA", "5G", "20M", "HT", "2T", "48", "38",
	"CHILE", "5G", "20M", "HT", "2T", "48", "52",
	"UKRAINE", "5G", "20M", "HT", "2T", "48", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "48", "50",
	"CN", "5G", "20M", "HT", "2T", "48", "38",
	"FCC", "5G", "20M", "HT", "2T", "52", "68",
	"ETSI", "5G", "20M", "HT", "2T", "52", "38",
	"MKK", "5G", "20M", "HT", "2T", "52", "50",
	"IC", "5G", "20M", "HT", "2T", "52", "40",
	"KCC", "5G", "20M", "HT", "2T", "52", "66",
	"ACMA", "5G", "20M", "HT", "2T", "52", "38",
	"CHILE", "5G", "20M", "HT", "2T", "52", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "52", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "52", "68",
	"CN", "5G", "20M", "HT", "2T", "52", "38",
	"FCC", "5G", "20M", "HT", "2T", "56", "68",
	"ETSI", "5G", "20M", "HT", "2T", "56", "38",
	"MKK", "5G", "20M", "HT", "2T", "56", "50",
	"IC", "5G", "20M", "HT", "2T", "56", "40",
	"KCC", "5G", "20M", "HT", "2T", "56", "66",
	"ACMA", "5G", "20M", "HT", "2T", "56", "38",
	"CHILE", "5G", "20M", "HT", "2T", "56", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "56", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "56", "68",
	"CN", "5G", "20M", "HT", "2T", "56", "38",
	"FCC", "5G", "20M", "HT", "2T", "60", "66",
	"ETSI", "5G", "20M", "HT", "2T", "60", "38",
	"MKK", "5G", "20M", "HT", "2T", "60", "50",
	"IC", "5G", "20M", "HT", "2T", "60", "40",
	"KCC", "5G", "20M", "HT", "2T", "60", "66",
	"ACMA", "5G", "20M", "HT", "2T", "60", "38",
	"CHILE", "5G", "20M", "HT", "2T", "60", "66",
	"UKRAINE", "5G", "20M", "HT", "2T", "60", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "60", "66",
	"CN", "5G", "20M", "HT", "2T", "60", "38",
	"FCC", "5G", "20M", "HT", "2T", "64", "68",
	"ETSI", "5G", "20M", "HT", "2T", "64", "38",
	"MKK", "5G", "20M", "HT", "2T", "64", "50",
	"IC", "5G", "20M", "HT", "2T", "64", "40",
	"KCC", "5G", "20M", "HT", "2T", "64", "66",
	"ACMA", "5G", "20M", "HT", "2T", "64", "38",
	"CHILE", "5G", "20M", "HT", "2T", "64", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "64", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "64", "68",
	"CN", "5G", "20M", "HT", "2T", "64", "38",
	"FCC", "5G", "20M", "HT", "2T", "100", "60",
	"ETSI", "5G", "20M", "HT", "2T", "100", "38",
	"MKK", "5G", "20M", "HT", "2T", "100", "70",
	"IC", "5G", "20M", "HT", "2T", "100", "60",
	"KCC", "5G", "20M", "HT", "2T", "100", "64",
	"ACMA", "5G", "20M", "HT", "2T", "100", "38",
	"CHILE", "5G", "20M", "HT", "2T", "100", "60",
	"UKRAINE", "5G", "20M", "HT", "2T", "100", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "100", "60",
	"CN", "5G", "20M", "HT", "2T", "100", "127",
	"FCC", "5G", "20M", "HT", "2T", "104", "68",
	"ETSI", "5G", "20M", "HT", "2T", "104", "38",
	"MKK", "5G", "20M", "HT", "2T", "104", "70",
	"IC", "5G", "20M", "HT", "2T", "104", "68",
	"KCC", "5G", "20M", "HT", "2T", "104", "64",
	"ACMA", "5G", "20M", "HT", "2T", "104", "38",
	"CHILE", "5G", "20M", "HT", "2T", "104", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "104", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "104", "68",
	"CN", "5G", "20M", "HT", "2T", "104", "127",
	"FCC", "5G", "20M", "HT", "2T", "108", "68",
	"ETSI", "5G", "20M", "HT", "2T", "108", "38",
	"MKK", "5G", "20M", "HT", "2T", "108", "70",
	"IC", "5G", "20M", "HT", "2T", "108", "68",
	"KCC", "5G", "20M", "HT", "2T", "108", "64",
	"ACMA", "5G", "20M", "HT", "2T", "108", "38",
	"CHILE", "5G", "20M", "HT", "2T", "108", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "108", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "108", "68",
	"CN", "5G", "20M", "HT", "2T", "108", "127",
	"FCC", "5G", "20M", "HT", "2T", "112", "68",
	"ETSI", "5G", "20M", "HT", "2T", "112", "38",
	"MKK", "5G", "20M", "HT", "2T", "112", "70",
	"IC", "5G", "20M", "HT", "2T", "112", "68",
	"KCC", "5G", "20M", "HT", "2T", "112", "64",
	"ACMA", "5G", "20M", "HT", "2T", "112", "38",
	"CHILE", "5G", "20M", "HT", "2T", "112", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "112", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "112", "68",
	"CN", "5G", "20M", "HT", "2T", "112", "127",
	"FCC", "5G", "20M", "HT", "2T", "116", "68",
	"ETSI", "5G", "20M", "HT", "2T", "116", "38",
	"MKK", "5G", "20M", "HT", "2T", "116", "70",
	"IC", "5G", "20M", "HT", "2T", "116", "68",
	"KCC", "5G", "20M", "HT", "2T", "116", "64",
	"ACMA", "5G", "20M", "HT", "2T", "116", "38",
	"CHILE", "5G", "20M", "HT", "2T", "116", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "116", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "116", "68",
	"CN", "5G", "20M", "HT", "2T", "116", "127",
	"FCC", "5G", "20M", "HT", "2T", "120", "68",
	"ETSI", "5G", "20M", "HT", "2T", "120", "38",
	"MKK", "5G", "20M", "HT", "2T", "120", "70",
	"IC", "5G", "20M", "HT", "2T", "120", "127",
	"KCC", "5G", "20M", "HT", "2T", "120", "64",
	"ACMA", "5G", "20M", "HT", "2T", "120", "127",
	"CHILE", "5G", "20M", "HT", "2T", "120", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "120", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "120", "68",
	"CN", "5G", "20M", "HT", "2T", "120", "127",
	"FCC", "5G", "20M", "HT", "2T", "124", "68",
	"ETSI", "5G", "20M", "HT", "2T", "124", "38",
	"MKK", "5G", "20M", "HT", "2T", "124", "70",
	"IC", "5G", "20M", "HT", "2T", "124", "127",
	"KCC", "5G", "20M", "HT", "2T", "124", "64",
	"ACMA", "5G", "20M", "HT", "2T", "124", "127",
	"CHILE", "5G", "20M", "HT", "2T", "124", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "124", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "124", "68",
	"CN", "5G", "20M", "HT", "2T", "124", "127",
	"FCC", "5G", "20M", "HT", "2T", "128", "68",
	"ETSI", "5G", "20M", "HT", "2T", "128", "38",
	"MKK", "5G", "20M", "HT", "2T", "128", "70",
	"IC", "5G", "20M", "HT", "2T", "128", "127",
	"KCC", "5G", "20M", "HT", "2T", "128", "64",
	"ACMA", "5G", "20M", "HT", "2T", "128", "127",
	"CHILE", "5G", "20M", "HT", "2T", "128", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "128", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "128", "68",
	"CN", "5G", "20M", "HT", "2T", "128", "127",
	"FCC", "5G", "20M", "HT", "2T", "132", "68",
	"ETSI", "5G", "20M", "HT", "2T", "132", "38",
	"MKK", "5G", "20M", "HT", "2T", "132", "70",
	"IC", "5G", "20M", "HT", "2T", "132", "68",
	"KCC", "5G", "20M", "HT", "2T", "132", "64",
	"ACMA", "5G", "20M", "HT", "2T", "132", "38",
	"CHILE", "5G", "20M", "HT", "2T", "132", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "132", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "132", "68",
	"CN", "5G", "20M", "HT", "2T", "132", "127",
	"FCC", "5G", "20M", "HT", "2T", "136", "68",
	"ETSI", "5G", "20M", "HT", "2T", "136", "38",
	"MKK", "5G", "20M", "HT", "2T", "136", "70",
	"IC", "5G", "20M", "HT", "2T", "136", "68",
	"KCC", "5G", "20M", "HT", "2T", "136", "64",
	"ACMA", "5G", "20M", "HT", "2T", "136", "38",
	"CHILE", "5G", "20M", "HT", "2T", "136", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "136", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "136", "68",
	"CN", "5G", "20M", "HT", "2T", "136", "127",
	"FCC", "5G", "20M", "HT", "2T", "140", "60",
	"ETSI", "5G", "20M", "HT", "2T", "140", "38",
	"MKK", "5G", "20M", "HT", "2T", "140", "70",
	"IC", "5G", "20M", "HT", "2T", "140", "60",
	"KCC", "5G", "20M", "HT", "2T", "140", "64",
	"ACMA", "5G", "20M", "HT", "2T", "140", "38",
	"CHILE", "5G", "20M", "HT", "2T", "140", "60",
	"UKRAINE", "5G", "20M", "HT", "2T", "140", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "140", "60",
	"CN", "5G", "20M", "HT", "2T", "140", "127",
	"FCC", "5G", "20M", "HT", "2T", "144", "68",
	"ETSI", "5G", "20M", "HT", "2T", "144", "127",
	"MKK", "5G", "20M", "HT", "2T", "144", "127",
	"IC", "5G", "20M", "HT", "2T", "144", "68",
	"KCC", "5G", "20M", "HT", "2T", "144", "64",
	"ACMA", "5G", "20M", "HT", "2T", "144", "127",
	"CHILE", "5G", "20M", "HT", "2T", "144", "68",
	"UKRAINE", "5G", "20M", "HT", "2T", "144", "127",
	"MEXICO", "5G", "20M", "HT", "2T", "144", "68",
	"CN", "5G", "20M", "HT", "2T", "144", "127",
	"FCC", "5G", "20M", "HT", "2T", "149", "76",
	"ETSI", "5G", "20M", "HT", "2T", "149", "-128",
	"MKK", "5G", "20M", "HT", "2T", "149", "127",
	"IC", "5G", "20M", "HT", "2T", "149", "76",
	"KCC", "5G", "20M", "HT", "2T", "149", "60",
	"ACMA", "5G", "20M", "HT", "2T", "149", "76",
	"CHILE", "5G", "20M", "HT", "2T", "149", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "149", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "149", "72",
	"CN", "5G", "20M", "HT", "2T", "149", "-128",
	"FCC", "5G", "20M", "HT", "2T", "153", "76",
	"ETSI", "5G", "20M", "HT", "2T", "153", "-128",
	"MKK", "5G", "20M", "HT", "2T", "153", "127",
	"IC", "5G", "20M", "HT", "2T", "153", "76",
	"KCC", "5G", "20M", "HT", "2T", "153", "60",
	"ACMA", "5G", "20M", "HT", "2T", "153", "76",
	"CHILE", "5G", "20M", "HT", "2T", "153", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "153", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "153", "76",
	"CN", "5G", "20M", "HT", "2T", "153", "-128",
	"FCC", "5G", "20M", "HT", "2T", "157", "76",
	"ETSI", "5G", "20M", "HT", "2T", "157", "-128",
	"MKK", "5G", "20M", "HT", "2T", "157", "127",
	"IC", "5G", "20M", "HT", "2T", "157", "76",
	"KCC", "5G", "20M", "HT", "2T", "157", "60",
	"ACMA", "5G", "20M", "HT", "2T", "157", "76",
	"CHILE", "5G", "20M", "HT", "2T", "157", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "157", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "157", "76",
	"CN", "5G", "20M", "HT", "2T", "157", "-128",
	"FCC", "5G", "20M", "HT", "2T", "161", "76",
	"ETSI", "5G", "20M", "HT", "2T", "161", "-128",
	"MKK", "5G", "20M", "HT", "2T", "161", "127",
	"IC", "5G", "20M", "HT", "2T", "161", "76",
	"KCC", "5G", "20M", "HT", "2T", "161", "60",
	"ACMA", "5G", "20M", "HT", "2T", "161", "76",
	"CHILE", "5G", "20M", "HT", "2T", "161", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "161", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "161", "76",
	"CN", "5G", "20M", "HT", "2T", "161", "-128",
	"FCC", "5G", "20M", "HT", "2T", "165", "76",
	"ETSI", "5G", "20M", "HT", "2T", "165", "-128",
	"MKK", "5G", "20M", "HT", "2T", "165", "127",
	"IC", "5G", "20M", "HT", "2T", "165", "76",
	"KCC", "5G", "20M", "HT", "2T", "165", "60",
	"ACMA", "5G", "20M", "HT", "2T", "165", "76",
	"CHILE", "5G", "20M", "HT", "2T", "165", "76",
	"UKRAINE", "5G", "20M", "HT", "2T", "165", "30",
	"MEXICO", "5G", "20M", "HT", "2T", "165", "76",
	"CN", "5G", "20M", "HT", "2T", "165", "-128",
	"FCC", "5G", "40M", "HT", "1T", "38", "66",
	"ETSI", "5G", "40M", "HT", "1T", "38", "64",
	"MKK", "5G", "40M", "HT", "1T", "38", "62",
	"IC", "5G", "40M", "HT", "1T", "38", "64",
	"KCC", "5G", "40M", "HT", "1T", "38", "72",
	"ACMA", "5G", "40M", "HT", "1T", "38", "64",
	"CHILE", "5G", "40M", "HT", "1T", "38", "64",
	"UKRAINE", "5G", "40M", "HT", "1T", "38", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "38", "62",
	"CN", "5G", "40M", "HT", "1T", "38", "64",
	"FCC", "5G", "40M", "HT", "1T", "46", "72",
	"ETSI", "5G", "40M", "HT", "1T", "46", "64",
	"MKK", "5G", "40M", "HT", "1T", "46", "62",
	"IC", "5G", "40M", "HT", "1T", "46", "64",
	"KCC", "5G", "40M", "HT", "1T", "46", "60",
	"ACMA", "5G", "40M", "HT", "1T", "46", "64",
	"CHILE", "5G", "40M", "HT", "1T", "46", "64",
	"UKRAINE", "5G", "40M", "HT", "1T", "46", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "46", "62",
	"CN", "5G", "40M", "HT", "1T", "46", "64",
	"FCC", "5G", "40M", "HT", "1T", "54", "72",
	"ETSI", "5G", "40M", "HT", "1T", "54", "64",
	"MKK", "5G", "40M", "HT", "1T", "54", "62",
	"IC", "5G", "40M", "HT", "1T", "54", "64",
	"KCC", "5G", "40M", "HT", "1T", "54", "72",
	"ACMA", "5G", "40M", "HT", "1T", "54", "64",
	"CHILE", "5G", "40M", "HT", "1T", "54", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "54", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "54", "72",
	"CN", "5G", "40M", "HT", "1T", "54", "64",
	"FCC", "5G", "40M", "HT", "1T", "62", "64",
	"ETSI", "5G", "40M", "HT", "1T", "62", "64",
	"MKK", "5G", "40M", "HT", "1T", "62", "62",
	"IC", "5G", "40M", "HT", "1T", "62", "64",
	"KCC", "5G", "40M", "HT", "1T", "62", "70",
	"ACMA", "5G", "40M", "HT", "1T", "62", "64",
	"CHILE", "5G", "40M", "HT", "1T", "62", "64",
	"UKRAINE", "5G", "40M", "HT", "1T", "62", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "62", "64",
	"CN", "5G", "40M", "HT", "1T", "62", "64",
	"FCC", "5G", "40M", "HT", "1T", "102", "58",
	"ETSI", "5G", "40M", "HT", "1T", "102", "64",
	"MKK", "5G", "40M", "HT", "1T", "102", "72",
	"IC", "5G", "40M", "HT", "1T", "102", "58",
	"KCC", "5G", "40M", "HT", "1T", "102", "72",
	"ACMA", "5G", "40M", "HT", "1T", "102", "64",
	"CHILE", "5G", "40M", "HT", "1T", "102", "58",
	"UKRAINE", "5G", "40M", "HT", "1T", "102", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "102", "58",
	"CN", "5G", "40M", "HT", "1T", "102", "127",
	"FCC", "5G", "40M", "HT", "1T", "110", "72",
	"ETSI", "5G", "40M", "HT", "1T", "110", "64",
	"MKK", "5G", "40M", "HT", "1T", "110", "72",
	"IC", "5G", "40M", "HT", "1T", "110", "72",
	"KCC", "5G", "40M", "HT", "1T", "110", "72",
	"ACMA", "5G", "40M", "HT", "1T", "110", "64",
	"CHILE", "5G", "40M", "HT", "1T", "110", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "110", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "110", "72",
	"CN", "5G", "40M", "HT", "1T", "110", "127",
	"FCC", "5G", "40M", "HT", "1T", "118", "72",
	"ETSI", "5G", "40M", "HT", "1T", "118", "64",
	"MKK", "5G", "40M", "HT", "1T", "118", "72",
	"IC", "5G", "40M", "HT", "1T", "118", "127",
	"KCC", "5G", "40M", "HT", "1T", "118", "72",
	"ACMA", "5G", "40M", "HT", "1T", "118", "127",
	"CHILE", "5G", "40M", "HT", "1T", "118", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "118", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "118", "72",
	"CN", "5G", "40M", "HT", "1T", "118", "127",
	"FCC", "5G", "40M", "HT", "1T", "126", "72",
	"ETSI", "5G", "40M", "HT", "1T", "126", "64",
	"MKK", "5G", "40M", "HT", "1T", "126", "72",
	"IC", "5G", "40M", "HT", "1T", "126", "127",
	"KCC", "5G", "40M", "HT", "1T", "126", "72",
	"ACMA", "5G", "40M", "HT", "1T", "126", "127",
	"CHILE", "5G", "40M", "HT", "1T", "126", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "126", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "126", "72",
	"CN", "5G", "40M", "HT", "1T", "126", "127",
	"FCC", "5G", "40M", "HT", "1T", "134", "72",
	"ETSI", "5G", "40M", "HT", "1T", "134", "64",
	"MKK", "5G", "40M", "HT", "1T", "134", "72",
	"IC", "5G", "40M", "HT", "1T", "134", "72",
	"KCC", "5G", "40M", "HT", "1T", "134", "72",
	"ACMA", "5G", "40M", "HT", "1T", "134", "64",
	"CHILE", "5G", "40M", "HT", "1T", "134", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "134", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "134", "72",
	"CN", "5G", "40M", "HT", "1T", "134", "127",
	"FCC", "5G", "40M", "HT", "1T", "142", "72",
	"ETSI", "5G", "40M", "HT", "1T", "142", "127",
	"MKK", "5G", "40M", "HT", "1T", "142", "127",
	"IC", "5G", "40M", "HT", "1T", "142", "72",
	"KCC", "5G", "40M", "HT", "1T", "142", "72",
	"ACMA", "5G", "40M", "HT", "1T", "142", "127",
	"CHILE", "5G", "40M", "HT", "1T", "142", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "142", "127",
	"MEXICO", "5G", "40M", "HT", "1T", "142", "72",
	"CN", "5G", "40M", "HT", "1T", "142", "127",
	"FCC", "5G", "40M", "HT", "1T", "151", "72",
	"ETSI", "5G", "40M", "HT", "1T", "151", "-128",
	"MKK", "5G", "40M", "HT", "1T", "151", "127",
	"IC", "5G", "40M", "HT", "1T", "151", "72",
	"KCC", "5G", "40M", "HT", "1T", "151", "72",
	"ACMA", "5G", "40M", "HT", "1T", "151", "72",
	"CHILE", "5G", "40M", "HT", "1T", "151", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "151", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "151", "72",
	"CN", "5G", "40M", "HT", "1T", "151", "-128",
	"FCC", "5G", "40M", "HT", "1T", "159", "72",
	"ETSI", "5G", "40M", "HT", "1T", "159", "-128",
	"MKK", "5G", "40M", "HT", "1T", "159", "127",
	"IC", "5G", "40M", "HT", "1T", "159", "72",
	"KCC", "5G", "40M", "HT", "1T", "159", "72",
	"ACMA", "5G", "40M", "HT", "1T", "159", "72",
	"CHILE", "5G", "40M", "HT", "1T", "159", "72",
	"UKRAINE", "5G", "40M", "HT", "1T", "159", "54",
	"MEXICO", "5G", "40M", "HT", "1T", "159", "72",
	"CN", "5G", "40M", "HT", "1T", "159", "-128",
	"FCC", "5G", "40M", "HT", "2T", "38", "60",
	"ETSI", "5G", "40M", "HT", "2T", "38", "40",
	"MKK", "5G", "40M", "HT", "2T", "38", "50",
	"IC", "5G", "40M", "HT", "2T", "38", "40",
	"KCC", "5G", "40M", "HT", "2T", "38", "62",
	"ACMA", "5G", "40M", "HT", "2T", "38", "40",
	"CHILE", "5G", "40M", "HT", "2T", "38", "52",
	"UKRAINE", "5G", "40M", "HT", "2T", "38", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "38", "50",
	"CN", "5G", "40M", "HT", "2T", "38", "40",
	"FCC", "5G", "40M", "HT", "2T", "46", "68",
	"ETSI", "5G", "40M", "HT", "2T", "46", "40",
	"MKK", "5G", "40M", "HT", "2T", "46", "50",
	"IC", "5G", "40M", "HT", "2T", "46", "40",
	"KCC", "5G", "40M", "HT", "2T", "46", "46",
	"ACMA", "5G", "40M", "HT", "2T", "46", "40",
	"CHILE", "5G", "40M", "HT", "2T", "46", "52",
	"UKRAINE", "5G", "40M", "HT", "2T", "46", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "46", "50",
	"CN", "5G", "40M", "HT", "2T", "46", "40",
	"FCC", "5G", "40M", "HT", "2T", "54", "68",
	"ETSI", "5G", "40M", "HT", "2T", "54", "40",
	"MKK", "5G", "40M", "HT", "2T", "54", "50",
	"IC", "5G", "40M", "HT", "2T", "54", "40",
	"KCC", "5G", "40M", "HT", "2T", "54", "62",
	"ACMA", "5G", "40M", "HT", "2T", "54", "40",
	"CHILE", "5G", "40M", "HT", "2T", "54", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "54", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "54", "68",
	"CN", "5G", "40M", "HT", "2T", "54", "40",
	"FCC", "5G", "40M", "HT", "2T", "62", "58",
	"ETSI", "5G", "40M", "HT", "2T", "62", "40",
	"MKK", "5G", "40M", "HT", "2T", "62", "48",
	"IC", "5G", "40M", "HT", "2T", "62", "40",
	"KCC", "5G", "40M", "HT", "2T", "62", "58",
	"ACMA", "5G", "40M", "HT", "2T", "62", "40",
	"CHILE", "5G", "40M", "HT", "2T", "62", "58",
	"UKRAINE", "5G", "40M", "HT", "2T", "62", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "62", "58",
	"CN", "5G", "40M", "HT", "2T", "62", "40",
	"FCC", "5G", "40M", "HT", "2T", "102", "54",
	"ETSI", "5G", "40M", "HT", "2T", "102", "40",
	"MKK", "5G", "40M", "HT", "2T", "102", "70",
	"IC", "5G", "40M", "HT", "2T", "102", "54",
	"KCC", "5G", "40M", "HT", "2T", "102", "64",
	"ACMA", "5G", "40M", "HT", "2T", "102", "40",
	"CHILE", "5G", "40M", "HT", "2T", "102", "54",
	"UKRAINE", "5G", "40M", "HT", "2T", "102", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "102", "54",
	"CN", "5G", "40M", "HT", "2T", "102", "127",
	"FCC", "5G", "40M", "HT", "2T", "110", "68",
	"ETSI", "5G", "40M", "HT", "2T", "110", "40",
	"MKK", "5G", "40M", "HT", "2T", "110", "70",
	"IC", "5G", "40M", "HT", "2T", "110", "68",
	"KCC", "5G", "40M", "HT", "2T", "110", "64",
	"ACMA", "5G", "40M", "HT", "2T", "110", "40",
	"CHILE", "5G", "40M", "HT", "2T", "110", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "110", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "110", "68",
	"CN", "5G", "40M", "HT", "2T", "110", "127",
	"FCC", "5G", "40M", "HT", "2T", "118", "68",
	"ETSI", "5G", "40M", "HT", "2T", "118", "40",
	"MKK", "5G", "40M", "HT", "2T", "118", "70",
	"IC", "5G", "40M", "HT", "2T", "118", "127",
	"KCC", "5G", "40M", "HT", "2T", "118", "64",
	"ACMA", "5G", "40M", "HT", "2T", "118", "127",
	"CHILE", "5G", "40M", "HT", "2T", "118", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "118", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "118", "68",
	"CN", "5G", "40M", "HT", "2T", "118", "127",
	"FCC", "5G", "40M", "HT", "2T", "126", "68",
	"ETSI", "5G", "40M", "HT", "2T", "126", "40",
	"MKK", "5G", "40M", "HT", "2T", "126", "70",
	"IC", "5G", "40M", "HT", "2T", "126", "127",
	"KCC", "5G", "40M", "HT", "2T", "126", "64",
	"ACMA", "5G", "40M", "HT", "2T", "126", "127",
	"CHILE", "5G", "40M", "HT", "2T", "126", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "126", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "126", "68",
	"CN", "5G", "40M", "HT", "2T", "126", "127",
	"FCC", "5G", "40M", "HT", "2T", "134", "68",
	"ETSI", "5G", "40M", "HT", "2T", "134", "40",
	"MKK", "5G", "40M", "HT", "2T", "134", "70",
	"IC", "5G", "40M", "HT", "2T", "134", "68",
	"KCC", "5G", "40M", "HT", "2T", "134", "64",
	"ACMA", "5G", "40M", "HT", "2T", "134", "40",
	"CHILE", "5G", "40M", "HT", "2T", "134", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "134", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "134", "68",
	"CN", "5G", "40M", "HT", "2T", "134", "127",
	"FCC", "5G", "40M", "HT", "2T", "142", "68",
	"ETSI", "5G", "40M", "HT", "2T", "142", "127",
	"MKK", "5G", "40M", "HT", "2T", "142", "127",
	"IC", "5G", "40M", "HT", "2T", "142", "68",
	"KCC", "5G", "40M", "HT", "2T", "142", "64",
	"ACMA", "5G", "40M", "HT", "2T", "142", "127",
	"CHILE", "5G", "40M", "HT", "2T", "142", "68",
	"UKRAINE", "5G", "40M", "HT", "2T", "142", "127",
	"MEXICO", "5G", "40M", "HT", "2T", "142", "68",
	"CN", "5G", "40M", "HT", "2T", "142", "127",
	"FCC", "5G", "40M", "HT", "2T", "151", "72",
	"ETSI", "5G", "40M", "HT", "2T", "151", "-128",
	"MKK", "5G", "40M", "HT", "2T", "151", "127",
	"IC", "5G", "40M", "HT", "2T", "151", "72",
	"KCC", "5G", "40M", "HT", "2T", "151", "66",
	"ACMA", "5G", "40M", "HT", "2T", "151", "72",
	"CHILE", "5G", "40M", "HT", "2T", "151", "72",
	"UKRAINE", "5G", "40M", "HT", "2T", "151", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "151", "68",
	"CN", "5G", "40M", "HT", "2T", "151", "-128",
	"FCC", "5G", "40M", "HT", "2T", "159", "72",
	"ETSI", "5G", "40M", "HT", "2T", "159", "-128",
	"MKK", "5G", "40M", "HT", "2T", "159", "127",
	"IC", "5G", "40M", "HT", "2T", "159", "72",
	"KCC", "5G", "40M", "HT", "2T", "159", "66",
	"ACMA", "5G", "40M", "HT", "2T", "159", "72",
	"CHILE", "5G", "40M", "HT", "2T", "159", "72",
	"UKRAINE", "5G", "40M", "HT", "2T", "159", "30",
	"MEXICO", "5G", "40M", "HT", "2T", "159", "72",
	"CN", "5G", "40M", "HT", "2T", "159", "-128",
	"FCC", "5G", "80M", "VHT", "1T", "42", "64",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "64",
	"MKK", "5G", "80M", "VHT", "1T", "42", "64",
	"IC", "5G", "80M", "VHT", "1T", "42", "64",
	"KCC", "5G", "80M", "VHT", "1T", "42", "68",
	"ACMA", "5G", "80M", "VHT", "1T", "42", "64",
	"CHILE", "5G", "80M", "VHT", "1T", "42", "64",
	"UKRAINE", "5G", "80M", "VHT", "1T", "42", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "42", "62",
	"CN", "5G", "80M", "VHT", "1T", "42", "64",
	"FCC", "5G", "80M", "VHT", "1T", "58", "62",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "64",
	"MKK", "5G", "80M", "VHT", "1T", "58", "64",
	"IC", "5G", "80M", "VHT", "1T", "58", "62",
	"KCC", "5G", "80M", "VHT", "1T", "58", "64",
	"ACMA", "5G", "80M", "VHT", "1T", "58", "64",
	"CHILE", "5G", "80M", "VHT", "1T", "58", "62",
	"UKRAINE", "5G", "80M", "VHT", "1T", "58", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "58", "62",
	"CN", "5G", "80M", "VHT", "1T", "58", "64",
	"FCC", "5G", "80M", "VHT", "1T", "106", "58",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "64",
	"MKK", "5G", "80M", "VHT", "1T", "106", "72",
	"IC", "5G", "80M", "VHT", "1T", "106", "58",
	"KCC", "5G", "80M", "VHT", "1T", "106", "66",
	"ACMA", "5G", "80M", "VHT", "1T", "106", "64",
	"CHILE", "5G", "80M", "VHT", "1T", "106", "58",
	"UKRAINE", "5G", "80M", "VHT", "1T", "106", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "106", "58",
	"CN", "5G", "80M", "VHT", "1T", "106", "127",
	"FCC", "5G", "80M", "VHT", "1T", "122", "72",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "64",
	"MKK", "5G", "80M", "VHT", "1T", "122", "72",
	"IC", "5G", "80M", "VHT", "1T", "122", "127",
	"KCC", "5G", "80M", "VHT", "1T", "122", "68",
	"ACMA", "5G", "80M", "VHT", "1T", "122", "127",
	"CHILE", "5G", "80M", "VHT", "1T", "122", "72",
	"UKRAINE", "5G", "80M", "VHT", "1T", "122", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "122", "72",
	"CN", "5G", "80M", "VHT", "1T", "122", "127",
	"FCC", "5G", "80M", "VHT", "1T", "138", "72",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "127",
	"MKK", "5G", "80M", "VHT", "1T", "138", "127",
	"IC", "5G", "80M", "VHT", "1T", "138", "72",
	"KCC", "5G", "80M", "VHT", "1T", "138", "68",
	"ACMA", "5G", "80M", "VHT", "1T", "138", "127",
	"CHILE", "5G", "80M", "VHT", "1T", "138", "72",
	"UKRAINE", "5G", "80M", "VHT", "1T", "138", "127",
	"MEXICO", "5G", "80M", "VHT", "1T", "138", "72",
	"CN", "5G", "80M", "VHT", "1T", "138", "127",
	"FCC", "5G", "80M", "VHT", "1T", "155", "72",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "-128",
	"MKK", "5G", "80M", "VHT", "1T", "155", "127",
	"IC", "5G", "80M", "VHT", "1T", "155", "72",
	"KCC", "5G", "80M", "VHT", "1T", "155", "68",
	"ACMA", "5G", "80M", "VHT", "1T", "155", "72",
	"CHILE", "5G", "80M", "VHT", "1T", "155", "72",
	"UKRAINE", "5G", "80M", "VHT", "1T", "155", "54",
	"MEXICO", "5G", "80M", "VHT", "1T", "155", "68",
	"CN", "5G", "80M", "VHT", "1T", "155", "-128",
	"FCC", "5G", "80M", "VHT", "2T", "42", "54",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "40",
	"MKK", "5G", "80M", "VHT", "2T", "42", "50",
	"IC", "5G", "80M", "VHT", "2T", "42", "40",
	"KCC", "5G", "80M", "VHT", "2T", "42", "58",
	"ACMA", "5G", "80M", "VHT", "2T", "42", "40",
	"CHILE", "5G", "80M", "VHT", "2T", "42", "52",
	"UKRAINE", "5G", "80M", "VHT", "2T", "42", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "42", "50",
	"CN", "5G", "80M", "VHT", "2T", "42", "40",
	"FCC", "5G", "80M", "VHT", "2T", "58", "52",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "40",
	"MKK", "5G", "80M", "VHT", "2T", "58", "50",
	"IC", "5G", "80M", "VHT", "2T", "58", "40",
	"KCC", "5G", "80M", "VHT", "2T", "58", "56",
	"ACMA", "5G", "80M", "VHT", "2T", "58", "40",
	"CHILE", "5G", "80M", "VHT", "2T", "58", "52",
	"UKRAINE", "5G", "80M", "VHT", "2T", "58", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "58", "52",
	"CN", "5G", "80M", "VHT", "2T", "58", "40",
	"FCC", "5G", "80M", "VHT", "2T", "106", "50",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "40",
	"MKK", "5G", "80M", "VHT", "2T", "106", "72",
	"IC", "5G", "80M", "VHT", "2T", "106", "50",
	"KCC", "5G", "80M", "VHT", "2T", "106", "56",
	"ACMA", "5G", "80M", "VHT", "2T", "106", "40",
	"CHILE", "5G", "80M", "VHT", "2T", "106", "50",
	"UKRAINE", "5G", "80M", "VHT", "2T", "106", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "106", "50",
	"CN", "5G", "80M", "VHT", "2T", "106", "127",
	"FCC", "5G", "80M", "VHT", "2T", "122", "66",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "40",
	"MKK", "5G", "80M", "VHT", "2T", "122", "72",
	"IC", "5G", "80M", "VHT", "2T", "122", "127",
	"KCC", "5G", "80M", "VHT", "2T", "122", "56",
	"ACMA", "5G", "80M", "VHT", "2T", "122", "127",
	"CHILE", "5G", "80M", "VHT", "2T", "122", "66",
	"UKRAINE", "5G", "80M", "VHT", "2T", "122", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "122", "66",
	"CN", "5G", "80M", "VHT", "2T", "122", "127",
	"FCC", "5G", "80M", "VHT", "2T", "138", "66",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "127",
	"MKK", "5G", "80M", "VHT", "2T", "138", "127",
	"IC", "5G", "80M", "VHT", "2T", "138", "66",
	"KCC", "5G", "80M", "VHT", "2T", "138", "58",
	"ACMA", "5G", "80M", "VHT", "2T", "138", "127",
	"CHILE", "5G", "80M", "VHT", "2T", "138", "66",
	"UKRAINE", "5G", "80M", "VHT", "2T", "138", "127",
	"MEXICO", "5G", "80M", "VHT", "2T", "138", "66",
	"CN", "5G", "80M", "VHT", "2T", "138", "127",
	"FCC", "5G", "80M", "VHT", "2T", "155", "62",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "-128",
	"MKK", "5G", "80M", "VHT", "2T", "155", "127",
	"IC", "5G", "80M", "VHT", "2T", "155", "62",
	"KCC", "5G", "80M", "VHT", "2T", "155", "58",
	"ACMA", "5G", "80M", "VHT", "2T", "155", "72",
	"CHILE", "5G", "80M", "VHT", "2T", "155", "62",
	"UKRAINE", "5G", "80M", "VHT", "2T", "155", "30",
	"MEXICO", "5G", "80M", "VHT", "2T", "155", "62",
	"CN", "5G", "80M", "VHT", "2T", "155", "-128"
};
#endif

void
odm_read_and_config_mp_8822c_txpwr_lmt_type5(struct dm_struct *dm)
{
#ifdef CONFIG_8822C_TYPE5

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822c_txpwr_lmt_type5) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822c_txpwr_lmt_type5;
#else
	u32	array_len =
			sizeof(array_mp_8822c_txpwr_lmt_type5) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822c_txpwr_lmt_type5;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822c(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

#endif /* end of HWIMG_SUPPORT*/

